/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.world_providers.base;

import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.new_content.building.DungeonUtils;
import com.robertx22.mine_and_slash.new_content.dimension.DungeonChunkGenerator;
import com.robertx22.mine_and_slash.onevent.player.OnDungeonBlockEvents;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.extensions.IForgeDimension;

public abstract class BaseDungeonDimension
extends Dimension
implements IWP,
IRarity,
ISlashRegistryEntry<BaseDungeonDimension> {
    public ModDimension moddim;
    private DimensionType type;
    public static final String RESETTABLE = "resettable";

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.WORLD_PROVIDER;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    public ResourceLocation res(String str) {
        return new ResourceLocation("mmorpg", str);
    }

    public BlockPos getEntrancePos(ChunkPos cpos, IWorld world) {
        return DungeonUtils.getDungeonStartTeleportPos(cpos);
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.world_type." + this.formattedGUID();
    }

    @Override
    public void setModDimension(ModDimension mod) {
        this.moddim = mod;
    }

    public abstract BiFunction<World, DimensionType, ? extends Dimension> classFactory();

    @Override
    public float getBonusLootMulti() {
        return 1.0f;
    }

    @Override
    public ModDimension newModDimension() {
        ModDimension mod = ModDimension.withFactory(this.classFactory());
        return mod;
    }

    public boolean func_191066_m() {
        return true;
    }

    @Nullable
    public BlockPos func_206921_a(int p_206921_1_, int p_206921_2_, boolean p_206921_3_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_206921_1_, 0, p_206921_2_);
        Biome biome = this.field_76579_a.func_226691_t_((BlockPos)blockpos$mutable);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (p_206921_3_ && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(p_206921_1_ >> 4, p_206921_2_ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, p_206921_1_ & 0xF, p_206921_2_ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, p_206921_1_ & 0xF, p_206921_2_ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, p_206921_1_ & 0xF, p_206921_2_ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutable.func_181079_c(p_206921_1_, j, p_206921_2_);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals(blockstate)) continue;
            return blockpos$mutable.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos p_206920_1_, boolean checkValid) {
        for (int i = p_206920_1_.func_180334_c(); i <= p_206920_1_.func_180332_e(); ++i) {
            for (int j = p_206920_1_.func_180333_d(); j <= p_206920_1_.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Override
    public ResourceLocation getResourceLoc() {
        return new ResourceLocation("mmorpg", "resettable_" + this.GUID());
    }

    public BaseDungeonDimension(World world, DimensionType type) {
        super(world, type, 0.0f);
        this.type = type;
        this.setModDim();
    }

    @Override
    public ModDimension getModDim() {
        return this.moddim;
    }

    public void setModDim() {
        this.moddim = this.newModDimension();
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.DENY;
    }

    public DimensionType getRespawnDimension(ServerPlayerEntity player) {
        return player.getSpawnDimension();
    }

    public float func_76571_f() {
        return 199.0f;
    }

    public boolean canMineBlock(PlayerEntity player, BlockPos pos) {
        try {
            Block block = this.getWorld().func_180495_p(pos).func_177230_c();
            if (block.func_203417_a(BlockTags.field_200152_g) || block.func_203417_a(BlockTags.field_212186_k)) {
                return true;
            }
            if (block == Blocks.field_150442_at || block.func_203417_a(BlockTags.field_200027_d) || block == Blocks.field_150383_bp) {
                return true;
            }
            if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_222422_lK || block == Blocks.field_222428_lQ) {
                return true;
            }
            if (block instanceof FenceGateBlock) {
                return true;
            }
            if (block instanceof ShulkerBoxBlock) {
                return true;
            }
            if (block.getRegistryName().toString().contains("gravestone")) {
                return true;
            }
            if (block.getRegistryName().toString().contains("gravestone_lite")) {
                return true;
            }
            if (block.getRegistryName().toString().contains("tombstone")) {
                return true;
            }
            if (block.getRegistryName().toString().contains("dank")) {
                return true;
            }
            if (OnDungeonBlockEvents.canBreakBlock(block)) {
                return true;
            }
            if (player.func_184812_l_()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public abstract BiomeProvider getBiomeProvider();

    @Nonnull
    public ChunkGenerator<?> func_186060_c() {
        BiomeProvider biomeProvider = this.getBiomeProvider();
        ChunkGeneratorType generator = new ChunkGeneratorType(DungeonChunkGenerator::new, true, OverworldGenSettings::new);
        OverworldGenSettings gensettings = new OverworldGenSettings();
        ChunkGenerator gen = generator.create(this.field_76579_a, biomeProvider, (GenerationSettings)gensettings);
        return gen;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public boolean func_76569_d() {
        return this.field_76579_a != null && this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        return false;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public long getWorldTime() {
        return 18000L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.func_76134_b((float)(p_76562_1_ * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public DimensionType func_186058_p() {
        return this.type;
    }
}

