/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.db_lists.bases;

import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.db_lists.bases.IRandom;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.List;
import java.util.stream.Collectors;

public interface IRandomDefault<T extends IhasRequirements & IWeighted>
extends IRandom<T, GearRequestedFor> {
    @Override
    default public T random(GearRequestedFor gearRequestedFor) {
        if (gearRequestedFor.gearData != null && gearRequestedFor.gearData.GetBaseGearType() == null) {
            System.out.println("Gear slot doesn't exist, or was renamed.");
            return null;
        }
        List allThatMeetReq = this.allThatMeetRequirement(this.All(), gearRequestedFor);
        if (allThatMeetReq.size() == 0) {
            System.out.println("No Matching item found for the gear requested, returning null.");
            return null;
        }
        return (T)((IhasRequirements)RandomUtils.weightedRandom(allThatMeetReq));
    }

    @Override
    default public T random() {
        return (T)((IhasRequirements)RandomUtils.weightedRandom(this.All()));
    }

    @Override
    default public List<T> allThatMeetRequirement(List<T> list, GearRequestedFor gearRequestedFor) {
        return list.stream().filter(x -> x.requirements().satisfiesAllRequirements(gearRequestedFor)).collect(Collectors.toList());
    }
}

