/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.dimensions;

import com.robertx22.mine_and_slash.database.world_providers.DungeonDimension;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MapManager {
    public static final String DUNGEON_ID = "mmorpg:resettable_dungeon";
    private static DimensionType DUNGEON_DIMENSION;

    public static DimensionType getDungeonDimensionType() {
        if (DUNGEON_DIMENSION != null) {
            return DUNGEON_DIMENSION;
        }
        return MapManager.getDimensionType(new ResourceLocation(DUNGEON_ID));
    }

    public static DimensionType getDimensionType(ResourceLocation res) {
        return DimensionType.func_193417_a((ResourceLocation)res);
    }

    public static DimensionType getDimensionType(PlayerMapCap.IPlayerMapData data) {
        return DimensionType.func_193417_a((ResourceLocation)data.getMap().getIWP().getResourceLoc());
    }

    public static boolean isRegistered(ResourceLocation res) {
        return DimensionType.func_193417_a((ResourceLocation)res) != null;
    }

    public static DimensionType fromResource(ResourceLocation res) {
        return DimensionType.func_193417_a((ResourceLocation)res);
    }

    public static String getId(IWorld world) {
        if (world.func_201675_m() instanceof DungeonDimension) {
            return DUNGEON_ID;
        }
        try {
            return MapManager.getResourceLocation(world.func_201675_m().func_186058_p()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static World getWorld(DimensionType type) {
        return MapManager.getServer().func_71218_a(type);
    }

    public static World getWorld(String res) {
        DimensionType type = MapManager.getDimensionType(new ResourceLocation(res));
        if (type == null) {
            return null;
        }
        return MapManager.getServer().func_71218_a(type);
    }

    public static ResourceLocation getResourceLocation(DimensionType type) {
        ResourceLocation loc = DimensionType.func_212678_a((DimensionType)type);
        return loc;
    }

    public static DimensionType setupPlayerMapDimension(PlayerEntity player, EntityCap.UnitData unit, MapItemData map, BlockPos pos) {
        DimensionType type = map.getDimension();
        PlayerMapCap.IPlayerMapData data = Load.playerMapData(player);
        data.init(pos, map, type, player);
        return type;
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Mod.EventBusSubscriber(modid="mmorpg")
    public static class EventDimensionType {
        @SubscribeEvent
        public static void dimReg(RegisterDimensionsEvent event) {
            ResourceLocation dunID = new ResourceLocation(MapManager.DUNGEON_ID);
            if (DimensionType.func_193417_a((ResourceLocation)dunID) == null) {
                ModDimension moddim = SlashRegistry.WorldProviders().get((String)new DungeonDimension(null, null).GUID()).moddim;
                DUNGEON_DIMENSION = DimensionManager.registerDimension((ResourceLocation)new ResourceLocation(MapManager.DUNGEON_ID), (ModDimension)moddim, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
                DimensionManager.keepLoaded((DimensionType)DUNGEON_DIMENSION, (boolean)false);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventMod {
        @SubscribeEvent
        public static void registerModDimensions(RegistryEvent.Register<ModDimension> event) {
            for (IWP iWP : SlashRegistry.WorldProviders().getList()) {
                ModDimension moddim = iWP.newModDimension();
                if (moddim.getRegistryName() == null) {
                    moddim.setRegistryName(iWP.getResourceLoc());
                }
                event.getRegistry().register((IForgeRegistryEntry)moddim);
                iWP.setModDimension(moddim);
            }
        }
    }
}

