/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.dimensions.blocks;

import com.google.common.cache.LoadingCache;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModBlocks;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class DungeonPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public DungeonPortalBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151646_E).func_200942_a().func_200951_a(11).func_200944_c().func_200943_b(-1.0f).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_195992_f().func_176735_f().func_176740_k());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity en) {
        try {
            if (!en.func_184218_aH() && !en.func_184207_aI() && en.func_184222_aU() && !worldIn.field_72995_K && en instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)en;
                if (WorldUtils.isMapWorldClass((IWorld)en.field_70170_p)) {
                    Load.playerMapData(player).teleportPlayerBack(player);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d1 = (double)pos.func_177956_o() + (double)rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld p_181089_0_, BlockPos worldIn) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size size = new Size(p_181089_0_, worldIn, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)p_181089_0_, (boolean)true);
        if (!size.isValid()) {
            direction$axis = Direction.Axis.X;
            size = new Size(p_181089_0_, worldIn, Direction.Axis.Z);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(worldIn, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = size.rightDir.func_176735_f();
        BlockPos blockpos = size.bottomLeft.func_177981_b(size.getHeight() - 1);
        for (Direction.AxisDirection dir : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper helper = new BlockPattern.PatternHelper(direction.func_176743_c() == dir ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)dir, (Direction.Axis)direction$axis), Direction.UP, loadingcache, size.getWidth(), size.getHeight(), 1);
            for (int i = 0; i < size.getWidth(); ++i) {
                for (int j = 0; j < size.getHeight(); ++j) {
                    CachedBlockInfo cachedblockinfo = helper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = dir.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection dir1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection dir2 : Direction.AxisDirection.values()) {
            if (aint[dir2.ordinal()] >= aint[dir1.ordinal()]) continue;
            dir1 = dir2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == dir1 ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)dir1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, size.getWidth(), size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.func_196900_a(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.isMyPortalFrame((IWorldReader)this.world, blockpos.func_177977_b()); ++i) {
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            return this.isMyPortalFrame((IWorldReader)this.world, framePos) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.func_196900_a(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == ModBlocks.DUNGEON_PORTAL.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.isMyPortalFrame((IWorldReader)this.world, framePos = blockpos.func_177972_a(this.leftDir)) : i == this.width - 1 && !this.isMyPortalFrame((IWorldReader)this.world, framePos = blockpos.func_177972_a(this.rightDir))) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                if (this.isMyPortalFrame((IWorldReader)this.world, framePos)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        boolean isMyPortalFrame(IWorldReader world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c() == ModBlocks.DUNGEON_PORTAL.get();
        }

        protected boolean func_196900_a(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == Blocks.field_150480_ab || block == ModBlocks.DUNGEON_PORTAL.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)((DungeonPortalBlock)ModBlocks.DUNGEON_PORTAL.get()).func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean func_208508_f() {
            return this.isValid() && this.func_196899_f();
        }
    }
}

