/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.dimensions.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.robertx22.mine_and_slash.dimensions.blocks.TileMapPortal;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapPortalRenderer
extends TileEntityRenderer<TileMapPortal> {
    public static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    public static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(p_228882_0_ -> RenderType.func_228630_a_((int)(p_228882_0_ + 1))).collect(ImmutableList.toImmutableList());

    public MapPortalRenderer(TileEntityRendererDispatcher p_i226019_1_) {
        super(p_i226019_1_);
    }

    public void render(TileMapPortal p_225616_1_, float p_225616_2_, MatrixStack p_225616_3_, IRenderTypeBuffer p_225616_4_, int p_225616_5_, int p_225616_6_) {
        RANDOM.setSeed(31100L);
        double lvt_7_1_ = p_225616_1_.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int lvt_9_1_ = this.getPasses(lvt_7_1_);
        float lvt_10_1_ = this.getOffset();
        Matrix4f lvt_11_1_ = p_225616_3_.func_227866_c_().func_227870_a_();
        this.renderCube(p_225616_1_, lvt_10_1_, 0.15f, lvt_11_1_, p_225616_4_.getBuffer(RENDER_TYPES.get(0)));
        for (int lvt_12_1_ = 1; lvt_12_1_ < lvt_9_1_; ++lvt_12_1_) {
            this.renderCube(p_225616_1_, lvt_10_1_, 2.0f / (float)(18 - lvt_12_1_), lvt_11_1_, p_225616_4_.getBuffer(RENDER_TYPES.get(lvt_12_1_)));
        }
    }

    private void renderCube(TileMapPortal p_228883_1_, float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, IVertexBuilder p_228883_5_) {
        float lvt_6_1_ = (RANDOM.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float lvt_7_1_ = (RANDOM.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float lvt_8_1_ = (RANDOM.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.SOUTH);
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.NORTH);
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.EAST);
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.WEST);
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.DOWN);
        this.renderFace(p_228883_1_, p_228883_4_, p_228883_5_, 0.0f, 1.0f, p_228883_2_, p_228883_2_, 1.0f, 1.0f, 0.0f, 0.0f, lvt_6_1_, lvt_7_1_, lvt_8_1_, Direction.UP);
    }

    private void renderFace(TileMapPortal p_228884_1_, Matrix4f p_228884_2_, IVertexBuilder p_228884_3_, float p_228884_4_, float p_228884_5_, float p_228884_6_, float p_228884_7_, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float p_228884_12_, float p_228884_13_, float p_228884_14_, Direction p_228884_15_) {
        if (p_228884_1_.shouldRenderFace(p_228884_15_)) {
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_4_, p_228884_6_, p_228884_8_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_5_, p_228884_6_, p_228884_9_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_5_, p_228884_7_, p_228884_10_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_4_, p_228884_7_, p_228884_11_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
        }
    }

    protected int getPasses(double p_191286_1_) {
        if (p_191286_1_ > 36864.0) {
            return 1;
        }
        if (p_191286_1_ > 25600.0) {
            return 3;
        }
        if (p_191286_1_ > 16384.0) {
            return 5;
        }
        if (p_191286_1_ > 9216.0) {
            return 7;
        }
        if (p_191286_1_ > 4096.0) {
            return 9;
        }
        if (p_191286_1_ > 1024.0) {
            return 11;
        }
        if (p_191286_1_ > 576.0) {
            return 13;
        }
        return p_191286_1_ > 256.0 ? 14 : 15;
    }

    protected float getOffset() {
        return 0.75f;
    }
}

