/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.dimensions.blocks;

import com.robertx22.mine_and_slash.database.world_providers.base.BaseDungeonDimension;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.onevent.world.OnShutdownResetMaps;
import com.robertx22.mine_and_slash.saveclasses.dungeon_dimension.DungeonDimensionData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.Statics;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileMapPortal
extends TileEntity {
    int ticks = 0;
    public String dungeonID = "";
    public MapItemData map = MapItemData.empty();
    public BlockPos mapDevicePos = new BlockPos(0, 0, 0);

    public TileMapPortal() {
        super((TileEntityType)ModTileEntities.MAP_PORTAL.get());
    }

    public void onTick() {
        ++this.ticks;
    }

    public void onMapSacrificed(BlockPos mapDevicePos, MapItemData map, String dungeonID) {
        this.mapDevicePos = mapDevicePos;
        this.map = map;
        this.dungeonID = dungeonID;
    }

    public void onKeySacrificed(BlockPos mapDevicePos, String dungeonID) {
        this.mapDevicePos = mapDevicePos;
        this.dungeonID = dungeonID;
        this.map = MapItemData.empty();
    }

    public boolean readyToTeleport() {
        if (this.ticks > 60) {
            this.ticks = 0;
            return true;
        }
        return false;
    }

    public void onDone(PlayerEntity player) {
        if (Statics.EMPTY_POS.equals((Object)this.field_174879_c)) {
            try {
                throw new Exception("Empty pos!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (WorldUtils.isMapWorldClass((IWorld)player.field_70170_p)) {
            Load.playerMapData(player).teleportPlayerBack(player);
        } else {
            ChunkPos cpos;
            DimensionType type = null;
            if (!this.map.isEmpty()) {
                type = this.map.getDimension();
            }
            if ((cpos = DungeonDimensionData.getChunkFromId(this.dungeonID)) != null) {
                PlayerMapCap.IPlayerMapData data = Load.playerMapData(player);
                data.init(this.mapDevicePos, this.map, type, player);
                World mapworld = MapManager.getWorld(type);
                try {
                    OnShutdownResetMaps.shouldDelete = Load.world(mapworld).shouldDeleteFolderOnServerShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (mapworld == null) {
                    return;
                }
                if (WorldUtils.isMapWorld((IWorld)mapworld)) {
                    BaseDungeonDimension dim = (BaseDungeonDimension)mapworld.func_201675_m();
                    BlockPos p = dim.getEntrancePos(cpos, (IWorld)mapworld);
                    PlayerUtils.changeDimension((ServerPlayerEntity)player, type, p);
                    MMORPG.devToolsLog("tp to map succeeded");
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFace(Direction face) {
        return face == Direction.UP;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        try {
            this.ticks = nbt.func_74762_e("ticks");
            this.dungeonID = nbt.func_74779_i("dungeon_id");
            try {
                this.mapDevicePos = new BlockPos(nbt.func_74762_e("xmap"), nbt.func_74762_e("ymap"), nbt.func_74762_e("zmap"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mapDevicePos == null || Statics.EMPTY_POS.equals((Object)this.mapDevicePos)) {
                this.mapDevicePos = this.func_174877_v().func_177984_a().func_177968_d();
            }
            this.map = Map.Load(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        try {
            nbt.func_74768_a("ticks", this.ticks);
            nbt.func_74778_a("dungeon_id", this.dungeonID);
            Map.Save(nbt, this.map);
            nbt.func_74768_a("xmap", this.mapDevicePos.func_177958_n());
            nbt.func_74768_a("ymap", this.mapDevicePos.func_177956_o());
            nbt.func_74768_a("zmap", this.mapDevicePos.func_177952_p());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }
}

