/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public abstract class BaseScrollbar
extends Widget {
    static ResourceLocation SCROLLBAR_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/scrollbar.png");
    static int sizeY = 27;
    static int sizeX = 6;
    protected double value = 0.0;
    int totalHeight;

    protected BaseScrollbar(int xpos, int ypos, int scrollbarTotalHeight) {
        super(xpos, ypos, sizeX, scrollbarTotalHeight, "");
        this.totalHeight = scrollbarTotalHeight;
    }

    protected void renderBg(Minecraft mc, int x, int y) {
        mc.func_110434_K().func_110577_a(SCROLLBAR_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xadd = (this.isHovered() ? 1 : 0) * sizeX;
        int yPos = this.getScrollBarY();
        this.blit(this.x, this.y, 50, 0, sizeX, this.totalHeight);
        this.blit(this.x, yPos, xadd, 0, sizeX, sizeY);
    }

    public int getScrollBarY() {
        int val = (int)((double)this.y + this.value * (double)this.totalHeight);
        return MathHelper.func_76125_a((int)(val - sizeY / 2), (int)this.y, (int)(this.y + this.totalHeight - sizeY));
    }

    public void renderButton(int x, int y, float f) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontrenderer = mc.field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.renderBg(mc, x, y);
    }

    public void onClick(double x, double y) {
        this.setValueFromMouse(y);
    }

    private void setValueFromMouse(double y) {
        this.setValue((y - (double)this.y) / (double)this.totalHeight);
    }

    private void setValue(double y) {
        double val = this.value;
        this.value = MathHelper.func_151237_a((double)y, (double)0.0, (double)1.0);
        if (val != this.value) {
            this.applyValue();
        }
    }

    public void setValueFromElement(int element, int max) {
        this.value = (float)element / (float)max;
    }

    protected void onDrag(double x, double y, double f3, double f4) {
        this.setValueFromMouse(y);
        super.onDrag(x, y, f3, f4);
    }

    public void onRelease(double x, double y) {
        super.playDownSound(Minecraft.func_71410_x().func_147118_V());
    }

    protected abstract void applyValue();
}

