/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.bases;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.database.talent_tree.PerkScreenContext;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.talent_tree_gui.PerkButton;
import com.robertx22.mine_and_slash.gui.screens.talent_tree_gui.PerkConnectionRender;
import com.robertx22.mine_and_slash.mmorpg.CapSyncCheck;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.RequestSyncCapToClient;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.talents.BasePerksData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.IPerkCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.lwjgl.opengl.GL11;

public abstract class BasePerkTreeScreen<T extends BasePerk, D extends BasePerksData<T>, C extends IPerkCap<T, D>>
extends Screen
implements INamedScreen {
    public Minecraft mc = Minecraft.func_71410_x();
    public EntityCap.UnitData unitData;
    public Set<PerkConnection> connections;
    public Set<PerkConnectionRender> buttonConnections;
    public C capData;
    public float scrollX = 0.0f;
    public float scrollY = 0.0f;
    public float zoom = 1.0f;
    public static int CENTER_X = 500;
    public static int CENTER_Y = 500;
    public float maxZoomOut = 0.23f;
    int ticks = 0;

    public abstract ResourceLocation getBorderTexture();

    public abstract ResourceLocation getSpaceTexture();

    public abstract ResourceLocation getLineTexture();

    public static int sizeX() {
        return Minecraft.func_71410_x().field_195558_d.func_198105_m();
    }

    public static int sizeY() {
        return Minecraft.func_71410_x().field_195558_d.func_198083_n();
    }

    public abstract PlayerCaps getCapType();

    public abstract void reloadData();

    public BasePerkTreeScreen() {
        super((ITextComponent)new StringTextComponent(""));
        this.unitData = Load.Unit((ICapabilityProvider)this.mc.field_71439_g);
        this.reloadData();
        this.requestSync();
    }

    public void requestSync() {
        MMORPG.sendToServer(new RequestSyncCapToClient(this.getCapType()));
    }

    public void refreshConnections() {
        this.connections = ((IPerkCap)this.capData).getConnections();
        this.buttonConnections = this.getButtonConnections();
    }

    public void init(Minecraft mc, int x, int y) {
        super.init(mc, x, y);
    }

    public void refresh() {
        MMORPG.sendToServer(new RequestSyncCapToClient(this.getCapType()));
        this.reloadData();
        this.refreshConnections();
        this.refreshAllocatedStatus();
    }

    public void refreshAllocatedStatus() {
        this.buttons.stream().filter(x -> x instanceof PerkButton).forEach(y -> {
            ((PerkButton)y).status = ((PerkButton)y).perk.getStatus((IPerkCap)this.capData);
        });
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean bool = super.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 32) {
            this.returnToCenter();
        }
        return bool;
    }

    public void returnToCenter() {
        this.scrollX = PerkButton.getSpacing() * CENTER_X;
        this.scrollY = PerkButton.getSpacing() * CENTER_Y;
        this.scrollX -= (float)(BasePerkTreeScreen.sizeX() / 2);
        this.scrollY -= (float)(BasePerkTreeScreen.sizeY() / 2);
        this.zoom = 0.6f;
    }

    public boolean mouseDragged(double x, double y, int ticks, double dragX, double dragY) {
        this.scrollX = (float)((double)this.scrollX - dragX * 1.0 / (double)this.zoom);
        this.scrollY = (float)((double)this.scrollY - dragY * 1.0 / (double)this.zoom);
        return true;
    }

    List<PerkButton> getTalentButtons() {
        ArrayList<PerkButton> list = new ArrayList<PerkButton>();
        for (Widget w : this.buttons) {
            if (!(w instanceof PerkButton)) continue;
            list.add((PerkButton)w);
        }
        return list;
    }

    public void render(int x, int y, float ticks) {
        ++this.ticks;
        if (CapSyncCheck.get(this.getCapType())) {
            this.refresh();
        }
        if (this.mc.field_71439_g.field_70173_aa % 100 == 0) {
            this.requestSync();
            this.refresh();
        }
        super.render(x, y, ticks);
        this.drawSpace();
        List<PerkButton> list = this.getTalentButtons();
        this.renderZoomables(x, y, ticks, list);
        this.drawPointsLeftNumber();
        this.renderTooltips(list, x, y);
    }

    public void renderZoomables(int x, int y, float ticks, List<PerkButton> list) {
        PerkScreenContext ctx = new PerkScreenContext(this);
        GL11.glScalef((float)this.zoom, (float)this.zoom, (float)this.zoom);
        this.renderConnections(list);
        for (PerkButton but : list) {
            but.renderButton(x, y, ctx);
        }
        float reset = 1.0f / this.zoom;
        GL11.glScalef((float)reset, (float)reset, (float)reset);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.zoom -= 0.1f;
        }
        if (scroll > 0.0) {
            this.zoom += 0.1f;
        }
        this.zoom = MathHelper.func_76131_a((float)this.zoom, (float)this.maxZoomOut, (float)1.0f);
        return true;
    }

    public void renderTooltips(List<PerkButton> list, int mouseX, int mouseY) {
        TooltipInfo info = new TooltipInfo((PlayerEntity)this.mc.field_71439_g);
        PerkScreenContext ctx = new PerkScreenContext(this);
        list.forEach(button -> {
            if (button.isInsideSlot(ctx, mouseX, mouseY)) {
                this.renderTooltip(TooltipUtils.compsToStrings(button.perk.effect.GetTooltipString(info)), mouseX, mouseY, this.mc.field_71466_p);
            }
        });
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.ticks < 100) {
            return false;
        }
        PerkScreenContext ctx = new PerkScreenContext(this);
        this.getTalentButtons().forEach(t -> t.onClick(ctx, (int)x, (int)y, button));
        boolean bool = super.mouseReleased(x, y, button);
        this.refresh();
        return bool;
    }

    public Set<PerkConnectionRender> getButtonConnections() {
        ObjectArraySet conns = new ObjectArraySet();
        List<PerkButton> list = this.getTalentButtons();
        for (PerkConnection connection : this.connections) {
            Optional<PerkButton> but1 = list.stream().filter(button -> button.perk.GUID().equals(connection.one.GUID())).findAny();
            Optional<PerkButton> but2 = list.stream().filter(button -> button.perk.GUID().equals(connection.two.GUID())).findAny();
            if (!but1.isPresent() || !but2.isPresent()) continue;
            conns.add(new PerkConnectionRender(but1.get(), but2.get(), connection));
        }
        return conns;
    }

    private void renderConnections(List<PerkButton> list) {
        PerkScreenContext ctx = new PerkScreenContext(this);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getLineTexture());
        for (PerkConnectionRender c : this.buttonConnections) {
            this.renderConnection(c.perk1, c.perk2, c.connection, ctx);
        }
    }

    public static boolean shouldRender(int x, int y, PerkScreenContext ctx, PerkType type) {
        int perkY;
        int perkX = type == null ? 5 : type.sizeX / 2;
        int n = perkY = type == null ? 5 : type.sizeY / 2;
        return x >= ctx.offsetX + 10 && (float)x < (float)ctx.offsetX + (float)(BasePerkTreeScreen.sizeX() - perkX) * ctx.getZoomMulti() - 10.0f && y >= ctx.offsetY + 10 && (float)y < (float)ctx.offsetY + (float)(BasePerkTreeScreen.sizeY() - perkY) * ctx.getZoomMulti() - 10.0f;
    }

    private void renderConnection(PerkButton one, PerkButton two, PerkConnection connection, PerkScreenContext ctx) {
        int x1 = one.getMiddleX(ctx);
        int y1 = one.getMiddleY(ctx);
        int x2 = two.getMiddleX(ctx);
        int y2 = two.getMiddleY(ctx);
        int size = 6;
        float spacing = size + size / 2;
        List<GuiUtils.PointF> points = GuiUtils.generateCurve(new GuiUtils.PointF(x1, y1), new GuiUtils.PointF(x2, y2), 360.0f, spacing, true);
        for (GuiUtils.PointF point : points) {
            int x = (int)(point.x - (float)size / 2.0f);
            int y = (int)(point.y - (float)size / 2.0f);
            if (!BasePerkTreeScreen.shouldRender(x, y, ctx, null)) continue;
            BasePerkTreeScreen.blit((int)x, (int)y, (int)0, (float)connection.allocationStatus.spriteOffsetX, (float)0.0f, (int)size, (int)size, (int)256, (int)256);
        }
    }

    protected void drawSpace() {
        int maxX = 5000;
        int maxY = 5000;
        float ticks = 0.0f;
        if (BasePerkTreeScreen.sizeX() > maxX || BasePerkTreeScreen.sizeY() > maxY) {
            this.renderDirtBackground(0);
        } else {
            float x = BasePerkTreeScreen.sizeX();
            float y = BasePerkTreeScreen.sizeY();
            float scale = x / (float)maxX;
            float antiScale = 1.0f / scale;
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offsetX = this.mc.field_195558_d.func_198107_o() / 2 - BasePerkTreeScreen.sizeX() / 2;
            int offsetY = this.mc.field_195558_d.func_198087_p() / 2 - BasePerkTreeScreen.sizeY() / 2;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSpaceTexture());
            BasePerkTreeScreen.blit((int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)5000, (int)5000, (int)5000, (int)5000);
            RenderSystem.scaled((double)antiScale, (double)antiScale, (double)antiScale);
        }
    }

    protected void drawPointsLeftNumber() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = 5;
        int offsetY = 5;
        String str2 = "Reset Points (RMB): " + ((BasePerksData)((IPerkCap)this.capData).getAbilitiesData()).resetPoints;
        this.mc.field_71466_p.func_175063_a(str2, (float)offsetX, (float)offsetY, TextFormatting.GREEN.func_211163_e().intValue());
        String str = "Points (LMB): " + ((IPerkCap)this.capData).getFreePoints(this.unitData);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        float f = offsetX;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_175063_a(str, f, (float)(offsetY + 9 + 5), TextFormatting.GREEN.func_211163_e().intValue());
    }
}

