/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.bar_overlays.bases;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public abstract class BaseBarsOverlay
extends AbstractGui {
    public static int BAR_WIDTH = 106;
    public static int BAR_HEIGHT = 11;
    public static final ResourceLocation MANA_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/mana_bar.png");
    public static final ResourceLocation ENE_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/energy_bar.png");
    public static final ResourceLocation HP_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/health_bar.png");
    public static final ResourceLocation EXP_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/experience_bar.png");
    public static final ResourceLocation MAG_SHIELD_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/magic_shield_bar.png");
    public static final ResourceLocation BLOOD_TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/blood_bar.png");

    public abstract void Draw(AbstractGui var1, Minecraft var2, LivingEntity var3, RenderGameOverlayEvent var4, EntityCap.UnitData var5);

    public void DrawBar(BarType type, EntityCap.UnitData data, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity p = mc.field_71439_g;
        float current = type.getCurrent((LivingEntity)p, data);
        float max = type.getMax((LivingEntity)p, data);
        current = MathHelper.func_76131_a((float)current, (float)0.0f, (float)max);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(type.getTex((LivingEntity)p, data));
        this.blit(x, y, 0, 0, BAR_WIDTH, BAR_HEIGHT);
        int barPercent = type.getBarPercent((LivingEntity)p, data);
        this.blit(x + 3, y + 3, 0, BAR_HEIGHT, barPercent, 5);
        type.renderExtra(this, x, y, (LivingEntity)p, data);
        String text = type.getText((LivingEntity)p, data);
        float textX = x + BAR_WIDTH / 2 - mc.field_71466_p.func_78256_a(text) / 2;
        float f = (float)y + (float)BAR_HEIGHT / 2.0f;
        mc.field_71466_p.getClass();
        float textY = f - 9.0f / 2.0f + 0.5f;
        mc.field_71466_p.func_175063_a(text, textX, textY, Color.LIGHT_GRAY.getRGB());
    }

    public static enum BarType {
        HP{

            @Override
            public ResourceLocation getTex(LivingEntity en, EntityCap.UnitData data) {
                return HP_TEX;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().health().CurrentValue(en, data.getUnit());
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().healthData().getAverageValue();
            }

            @Override
            public void renderExtra(AbstractGui gui, int x, int y, LivingEntity en, EntityCap.UnitData data) {
                float curMS = data.getResources().getMagicShield();
                if (curMS > 0.0f) {
                    float maxHP = data.getUnit().healthData().getAverageValue();
                    float maxperc = MathHelper.func_76131_a((float)(curMS / maxHP), (float)0.0f, (float)1.0f);
                    int barPercent = (int)((float)((int)(curMS / data.getUnit().magicShieldData().getAverageValue() * 100.0f)) * maxperc);
                    barPercent = MathHelper.func_76125_a((int)barPercent, (int)0, (int)100);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(MAG_SHIELD_TEX);
                    gui.blit(x + 3, y + 3, 0, BAR_HEIGHT, barPercent, 5);
                }
            }

            @Override
            public float getCurrentForDisplay(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().getCurrentEffectiveHealth(en, data);
            }

            @Override
            public float getMaxForDisplay(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().getMaxEffectiveHealth();
            }
        }
        ,
        MANA{

            @Override
            public ResourceLocation getTex(LivingEntity en, EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return BLOOD_TEX;
                }
                return MANA_TEX;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return data.getResources().getBlood();
                }
                return data.getResources().getMana();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return data.getUnit().getMaximumBlood();
                }
                return data.getUnit().manaData().getAverageValue();
            }
        }
        ,
        ENE{

            @Override
            public ResourceLocation getTex(LivingEntity en, EntityCap.UnitData data) {
                return ENE_TEX;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                return data.getResources().getEnergy();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().energyData().getAverageValue();
            }
        }
        ,
        EXP{

            @Override
            public ResourceLocation getTex(LivingEntity en, EntityCap.UnitData data) {
                return EXP_TEX;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                return data.getExp();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                return data.getExpRequiredForLevelUp();
            }

            @Override
            public String getText(LivingEntity en, EntityCap.UnitData data) {
                String now = NumberUtils.formatNumber((int)this.getCurrentForDisplay(en, data));
                String maximum = NumberUtils.formatNumber((int)this.getMaxForDisplay(en, data));
                return "Lvl:" + data.getLevel() + " " + now + "/" + maximum;
            }
        };


        public abstract ResourceLocation getTex(LivingEntity var1, EntityCap.UnitData var2);

        public int getBarPercent(LivingEntity en, EntityCap.UnitData data) {
            return MathHelper.func_76125_a((int)((int)(this.getCurrent(en, data) / this.getMax(en, data) * 100.0f)), (int)0, (int)100);
        }

        public abstract float getCurrent(LivingEntity var1, EntityCap.UnitData var2);

        public abstract float getMax(LivingEntity var1, EntityCap.UnitData var2);

        public float getCurrentForDisplay(LivingEntity en, EntityCap.UnitData data) {
            return this.getCurrent(en, data);
        }

        public float getMaxForDisplay(LivingEntity en, EntityCap.UnitData data) {
            return this.getMax(en, data);
        }

        public String getText(LivingEntity en, EntityCap.UnitData data) {
            String now = NumberUtils.formatNumber((int)this.getCurrentForDisplay(en, data));
            String maximum = NumberUtils.formatNumber((int)this.getMaxForDisplay(en, data));
            return now + "/" + maximum;
        }

        public void renderExtra(AbstractGui gui, int x, int y, LivingEntity en, EntityCap.UnitData data) {
        }
    }
}

