/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.bar_overlays.types;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.config.forge.ClientContainer;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayerGUIs;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaOverlay
extends IngameGui {
    int field_73837_f = 0;
    HashMap<Type, Integer> lastValues = new HashMap();
    HashMap<Type, Integer> changedTicksLeft = new HashMap();

    public VanillaOverlay(Minecraft mc) {
        super(mc);
    }

    public static int fix(int old, int scaledHeight) {
        int leftHeight = ForgeIngameGui.left_height;
        int rightHeight = ForgeIngameGui.right_height;
        int offsetHeight = Math.max(leftHeight, rightHeight);
        if (offsetHeight > 59) {
            return scaledHeight - offsetHeight;
        }
        return old;
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent event) {
        try {
            if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
                return;
            }
            if (!((PlayerGUIs)((Object)ClientContainer.INSTANCE.PLAYER_GUI_TYPE.get())).equals((Object)PlayerGUIs.Vanilla)) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity en = mc.field_71439_g;
            EntityCap.UnitData data = Load.Unit((ICapabilityProvider)en);
            if (en.func_184812_l_() || en.func_175149_v()) {
                return;
            }
            if (en == null || data == null) {
                return;
            }
            ++this.field_73837_f;
            ResourceLocation TEX = new ResourceLocation("mmorpg", "textures/gui/overlay/vanilla_overlay.png");
            mc.func_110434_K().func_110577_a(TEX);
            int SPACING_Y = 10;
            int width = event.getWindow().func_198107_o();
            int height = event.getWindow().func_198087_p();
            int x = width / 2 - 91;
            int y = height - 39 - SPACING_Y;
            if (en.func_70658_aO() > 0) {
                y -= SPACING_Y;
            }
            int leftY = (Integer)ClientContainer.INSTANCE.LEFT_VANILLA_LIKE_BARS_Y__POS_ADJUST.get();
            int rightY = (Integer)ClientContainer.INSTANCE.RIGHT_VANILLA_LIKE_BARS_Y__POS_ADJUST.get();
            this.renderElement(this.field_73837_f, Type.MAGIC_SHIELD, x, y + leftY, mc, (LivingEntity)en, data);
            x = width / 2 + 81;
            y = height - 39 - SPACING_Y;
            int air = en.func_70086_ai();
            if (en.func_208600_a(FluidTags.field_206959_a) || air < 300) {
                y -= SPACING_Y;
            }
            this.renderElement(this.field_73837_f, Type.MANA, x, y + rightY, mc, (LivingEntity)en, data);
            this.renderElement(this.field_73837_f, Type.ENERGY, x, (y -= SPACING_Y) + rightY, mc, (LivingEntity)en, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderElement(int ticks, Type type, int x, int y, Minecraft mc, LivingEntity en, EntityCap.UnitData data) {
        boolean needsRegen;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int current = (int)type.getCurrent(en, data);
        int max = (int)type.getMax(en, data);
        boolean changed = this.lastValues.getOrDefault((Object)type, 0) != current;
        int changedTicksRem = this.changedTicksLeft.getOrDefault((Object)type, 0);
        if (changed) {
            this.changedTicksLeft.put(type, 10);
        } else {
            this.changedTicksLeft.put(type, changedTicksRem - 1);
        }
        changedTicksRem = this.changedTicksLeft.getOrDefault((Object)type, 0);
        this.lastValues.put(type, current);
        boolean bl = needsRegen = current < max;
        if (max < 1) {
            return;
        }
        int tenth = max / 10;
        int X_SPACING = 8;
        int halfSpacing = type.getSide().equals((Object)Side.LEFT) ? 0 : 5;
        for (int i = 0; i < 10; ++i) {
            int randomY = 0;
            if (changedTicksRem > 0) {
                randomY = this.field_73842_c.nextInt(3) - 1;
            }
            this.blit(x, y + randomY, 16, type.yPosTexture(data), 9, 9);
            if (current > 0) {
                if (current >= tenth) {
                    this.blit(x, y + randomY, 0, type.yPosTexture(data), 9, 9);
                } else {
                    this.blit(x + halfSpacing, y + randomY, 10, type.yPosTexture(data), 5, 9);
                }
            }
            x = type.getSide().equals((Object)Side.LEFT) ? (x += X_SPACING) : (x -= X_SPACING);
            current -= tenth;
        }
        RenderSystem.disableBlend();
    }

    static enum Side {
        LEFT,
        RIGHT;

    }

    public static enum Type {
        MANA{

            @Override
            public Side getSide() {
                return Side.RIGHT;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return data.getResources().getBlood();
                }
                return data.getResources().getMana();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return data.getUnit().getMaximumBlood();
                }
                return data.getUnit().manaData().getAverageValue();
            }

            @Override
            public int yPosTexture(EntityCap.UnitData data) {
                if (data.getUnit().isBloodMage()) {
                    return 30;
                }
                return 10;
            }
        }
        ,
        ENERGY{

            @Override
            public Side getSide() {
                return Side.RIGHT;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                return data.getResources().getEnergy();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().energyData().getAverageValue();
            }

            @Override
            public int yPosTexture(EntityCap.UnitData data) {
                return 20;
            }
        }
        ,
        MAGIC_SHIELD{

            @Override
            public Side getSide() {
                return Side.LEFT;
            }

            @Override
            public float getCurrent(LivingEntity en, EntityCap.UnitData data) {
                return data.getResources().getMagicShield();
            }

            @Override
            public float getMax(LivingEntity en, EntityCap.UnitData data) {
                return data.getUnit().magicShieldData().getAverageValue();
            }

            @Override
            public int yPosTexture(EntityCap.UnitData data) {
                return 0;
            }
        };


        public abstract Side getSide();

        public abstract float getCurrent(LivingEntity var1, EntityCap.UnitData var2);

        public abstract float getMax(LivingEntity var1, EntityCap.UnitData var2);

        public abstract int yPosTexture(EntityCap.UnitData var1);
    }
}

