/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.mob_bar;

import com.robertx22.mine_and_slash.config.forge.ClientContainer;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LookUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobBarScreen
extends AbstractGui {
    private Minecraft mc;
    ResourceLocation TEX = new ResourceLocation("mmorpg", "textures/gui/mob_bar/mob_bar.png");
    int xSize = 102;
    int ySize = 7;
    LivingEntity en;
    int ticks = 0;

    public MobBarScreen(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderPlayerOverlay(RenderGameOverlayEvent event) {
        try {
            EntityCap.UnitData data;
            if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
                return;
            }
            if (!((Boolean)ClientContainer.INSTANCE.RENDER_SIMPLE_MOB_BAR.get()).booleanValue()) {
                return;
            }
            Entity e = LookUtils.getEntityLookedAt((Entity)this.mc.field_71439_g);
            if (e instanceof LivingEntity) {
                this.en = (LivingEntity)e;
            } else {
                ++this.ticks;
                if (this.ticks > 20) {
                    this.en = null;
                    this.ticks = 0;
                }
            }
            if (this.en != null && (data = Load.Unit((ICapabilityProvider)this.en)) != null && data.getUnit() != null) {
                int currentHp = (int)data.getUnit().getCurrentEffectiveHealth(this.en, data);
                int maxHP = (int)data.getUnit().getMaxEffectiveHealth();
                int percent = Math.round((float)currentHp / (float)maxHP * 100.0f);
                int height = this.mc.field_195558_d.func_198087_p();
                int width = this.mc.field_195558_d.func_198107_o();
                int x = width / 2 - this.xSize / 2;
                int y = 30;
                this.mc.func_110434_K().func_110577_a(this.TEX);
                this.blit(x, y, 0, 0, this.xSize, this.ySize);
                this.blit(x, y, 0, this.ySize, (int)((float)this.xSize * (float)percent / 100.0f), this.ySize);
                String name = CLOC.translate(data.getName(this.en));
                this.mc.field_71466_p.func_175063_a(name, (float)(width / 2 - this.mc.field_71466_p.func_78256_a(name) / 2), (float)(y - 10), TextFormatting.WHITE.func_211163_e().intValue());
                String hpText = currentHp + "/" + maxHP;
                GuiUtils.renderScaledText(width / 2, (int)((float)y + (float)this.ySize / 2.0f) + 1, 0.75, hpText, TextFormatting.GREEN);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

