/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_cast_bar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.BossInfo;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpellCastBarOverlay
extends AbstractGui {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    static int WIDTH = 182;
    static int HEIGHT = 5;
    Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderPlayerOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        PlayerSpellCap.ISpellsCap data = Load.spells((LivingEntity)this.mc.field_71439_g);
        if (data.getCastingData().isCasting()) {
            int x = this.mc.field_195558_d.func_198107_o() / 2 - WIDTH / 2;
            int y = (int)((float)this.mc.field_195558_d.func_198087_p() / 1.25f - (float)(HEIGHT / 2));
            float percent = ((float)data.getCastingData().lastSpellCastTimeInTicks - (float)data.getCastingData().castingTicksLeft) / (float)data.getCastingData().lastSpellCastTimeInTicks;
            this.render(x, y, BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20, percent);
        }
    }

    private void render(int x, int y, BossInfo.Color color, BossInfo.Overlay overlay, float percent) {
        int i;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
        this.blit(x, y, 0, color.ordinal() * 5 * 2, WIDTH, HEIGHT);
        if (overlay != BossInfo.Overlay.PROGRESS) {
            this.blit(x, y, 0, 80 + (overlay.ordinal() - 1) * 5 * 2, WIDTH, HEIGHT);
        }
        if ((i = (int)(percent * 183.0f)) > 0) {
            this.blit(x, y, 0, color.ordinal() * 5 * 2 + 5, i, HEIGHT);
            if (overlay != BossInfo.Overlay.PROGRESS) {
                this.blit(x, y, 0, 80 + (overlay.ordinal() - 1) * 5 * 2 + 5, i, HEIGHT);
            }
        }
    }
}

