/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.onevent.ontick.OnClientTick;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpellHotbarOverlay
extends AbstractGui {
    public static SpellCastingData.Hotbar CURRENT_HOTBAR = SpellCastingData.Hotbar.FIRST;
    private static final ResourceLocation HOTBAR_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/hotbar.png");
    private static final ResourceLocation COOLDOWN_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/cooldown.png");
    private static final ResourceLocation SPELL_READY_TEXT = new ResourceLocation("mmorpg", "textures/gui/spells/spell_ready.png");
    static int WIDTH = 22;
    static int HEIGHT = 102;
    Minecraft mc = Minecraft.func_71410_x();
    PlayerSpellCap.ISpellsCap data;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderPlayerOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (this.mc.field_71439_g.func_175149_v()) {
            return;
        }
        this.data = Load.spells((LivingEntity)this.mc.field_71439_g);
        int x = 0;
        int y = this.mc.field_195558_d.func_198087_p() / 2 - HEIGHT / 2;
        RenderSystem.enableBlend();
        this.renderHotbar(x, y);
        this.renderSpellsOnHotbar(x, y);
        RenderSystem.disableBlend();
    }

    private void renderSpellsOnHotbar(int x, int y) {
        x += 3;
        y += 3;
        for (int i = 0; i < 5; ++i) {
            BaseSpell spell = this.data.getSpellByKeybind(i, CURRENT_HOTBAR);
            if (spell != null) {
                double scale = 0.5;
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                int xs = (int)((double)(x * 1) / scale);
                int ys = (int)((double)(y * 1) / scale);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(spell.getIconLoc());
                SpellHotbarOverlay.blit((int)xs, (int)ys, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                SpellData spelldata = this.data.getCastingData().getDataBySpell(spell);
                if (spelldata != null && !spelldata.cooldownIsReady()) {
                    float percent = (float)spelldata.getRemainingCooldown() / (float)spelldata.getTotalCooldown();
                    percent = MathHelper.func_76131_a((float)percent, (float)0.0f, (float)1.0f);
                    this.mc.func_110434_K().func_110577_a(COOLDOWN_TEX);
                    SpellHotbarOverlay.blit((int)xs, (int)ys, (float)0.0f, (float)0.0f, (int)32, (int)((int)(32.0f * percent)), (int)32, (int)32);
                }
                RenderSystem.scaled((double)(1.0 / scale), (double)(1.0 / scale), (double)(1.0 / scale));
                if (spelldata != null && spelldata.cooldownIsReady() && OnClientTick.COOLDOWN_READY_MAP.getOrDefault(spell.GUID(), 0) > 0) {
                    RenderSystem.enableBlend();
                    this.mc.func_110434_K().func_110577_a(SPELL_READY_TEXT);
                    SpellHotbarOverlay.blit((int)(x - 2), (int)(y - 2), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
                    RenderSystem.disableBlend();
                }
            }
            y += 20;
        }
    }

    private void renderHotbar(int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(HOTBAR_TEX);
        this.blit(x, y, 0, 0, WIDTH, HEIGHT);
    }
}

