/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.bestiary;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.gui.BaseScrollbar;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.bestiary.BestiaryEntry;
import com.robertx22.mine_and_slash.gui.screens.bestiary.groups.BestiaryGroup;
import com.robertx22.mine_and_slash.gui.screens.bestiary.groups.UniqueGearBestiary;
import com.robertx22.mine_and_slash.gui.screens.main_hub.MainHubScreen;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BestiaryScreen
extends BaseScreen
implements INamedScreen {
    ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/bestiary.png");
    ResourceLocation BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/buttons.png");
    ResourceLocation SPLITTER_BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/split.png");
    ResourceLocation GROUP_BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/bestiary_group_buttons.png");
    public Minecraft mc;
    public static int entryButtonX = 235;
    public static int entryButtonY = 24;
    public static int groupButtonX = 20;
    public static int groupButtonY = 20;
    Scrollbar scrollbar;
    static int x = 276;
    static int y = 200;
    public BestiaryGroup currentBestiaryGroup = new UniqueGearBestiary();
    int currentElement = 0;
    public List<BestiaryEntry> entries = new ArrayList<BestiaryEntry>();
    int level = 1;
    int elementsAmount = 1;
    int entryButtonsAtOnce = 7;
    static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/back_button.png");

    public BestiaryScreen() {
        super(x, y);
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    protected void init() {
        super.init();
        this.addButton((Widget)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
        this.level = Load.Unit((ICapabilityProvider)this.mc.field_71439_g).getLevel();
        this.initEntries();
        this.setupEntryButtons();
        this.setupGroupButtons();
        this.setupScrollbar();
    }

    public void setupScrollbar() {
        int sliderXSize = 10;
        int sliderYSize = 30;
        int sliderX = this.guiLeft + 262;
        int sliderY = this.guiTop + 18;
        this.scrollbar = (Scrollbar)this.addButton(new Scrollbar(sliderX, sliderY, 174));
    }

    public void initEntries() {
        this.entries = this.currentBestiaryGroup.getDefaultSplitter().split(this.level);
        this.elementsAmount = this.entries.size();
    }

    public void setupGroupButtons() {
        int gx = this.guiLeft + 5;
        int gy = this.guiTop + 18;
        for (BestiaryGroup bestiaryGroup : BestiaryGroup.getAll()) {
            this.addButton((Widget)new GroupButton(this, bestiaryGroup, gx, gy));
            gy += groupButtonY;
        }
    }

    public void setupEntryButtons() {
        this.buttons.removeIf(x -> x instanceof EntryButton || x instanceof SplitterButton);
        int x2 = this.guiLeft + 27;
        int y = this.guiTop + 19;
        for (int i = this.currentElement; i < this.currentElement + this.entryButtonsAtOnce; ++i) {
            if (i >= this.elementsAmount) continue;
            BestiaryEntry entry = this.entries.get(i);
            if (entry instanceof BestiaryEntry.Splitter) {
                this.addButton((Widget)new SplitterButton((BestiaryEntry.Splitter)entry, x2, y));
                y += entryButtonY + 0;
                continue;
            }
            if (!(entry instanceof BestiaryEntry.Item)) continue;
            this.addButton((Widget)new EntryButton((BestiaryEntry.Item)entry, x2, y));
            y += entryButtonY + 0;
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawBackground(ticks, x, y);
        super.render(x, y, ticks);
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    protected void drawBackground(float partialTicks, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BACKGROUND_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BestiaryScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)BestiaryScreen.x, (int)BestiaryScreen.y, (int)256, (int)512);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/bestiary.png");
    }

    @Override
    public Words screenName() {
        return Words.Compendium;
    }

    public boolean mouseScrolled(double num1, double num2, double num3) {
        this.setCurrentElement((int)((double)this.currentElement - num3));
        return super.mouseScrolled(num1, num2, num3);
    }

    public void setCurrentElement(int element) {
        this.currentElement = MathHelper.func_76125_a((int)element, (int)0, (int)this.elementsAmount);
        this.scrollbar.setValueFromElement(this.currentElement, this.elementsAmount);
        this.setupEntryButtons();
    }

    public boolean mouseReleased(double m1, double m2, int m3) {
        this.setDragging(false);
        this.buttons.stream().filter(x -> x.isMouseOver(m1, m2)).findFirst().ifPresent(x -> x.onClick(m1, m2));
        return super.mouseReleased(m1, m2, m3);
    }

    public void setGroup(BestiaryGroup group) {
        this.currentBestiaryGroup = group;
        this.initEntries();
        this.setCurrentElement(0);
        this.setupEntryButtons();
    }

    static class BackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainHubScreen()));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    class EntryButton
    extends ImageButton {
        BestiaryEntry.Item item;

        public EntryButton(BestiaryEntry.Item item, int xPos, int yPos) {
            super(xPos, yPos, entryButtonX, entryButtonY, 0, 0, entryButtonY, BestiaryScreen.this.BUTTON_TEXTURE, button -> {});
            this.item = item;
        }

        int getStackY() {
            return this.y + 4;
        }

        int getStackX() {
            return this.x + 13;
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
            if (this.item != null) {
                BestiaryScreen.this.mc.func_175599_af().func_180450_b(this.item.stack, this.getStackX(), this.getStackY());
                int xp = this.x + 35;
                int n = this.y + entryButtonY / 2;
                BestiaryScreen.this.mc.field_71466_p.getClass();
                int yp = n - 9 / 2;
                BestiaryScreen.this.mc.field_71466_p.func_175063_a(this.item.getName(), (float)xp, (float)yp, TextFormatting.GREEN.func_211163_e().intValue());
            }
        }

        public void renderToolTip(int x, int y) {
            if (GuiUtils.isInRect(this.getStackX(), this.getStackY(), 18, 18, x, y)) {
                BestiaryScreen.this.renderTooltip(this.item.stack, x, y);
            }
        }
    }

    class GroupButton
    extends ImageButton {
        BestiaryGroup group;
        BestiaryScreen screen;

        public GroupButton(BestiaryScreen screen, BestiaryGroup group, int xPos, int yPos) {
            super(xPos, yPos, groupButtonX, groupButtonY, 0, 0, groupButtonY, BestiaryScreen.this.GROUP_BUTTON_TEXTURE, button -> {});
            this.screen = screen;
            this.group = group;
        }

        public void onPress() {
            super.onPress();
            this.screen.setGroup(this.group);
        }

        public void renderToolTip(int x, int y) {
            if (this.isHovered) {
                BestiaryScreen.this.renderTooltip(Arrays.asList(TextFormatting.BLUE + "" + TextFormatting.BOLD + CLOC.translate(this.group.getName())), x, y, Minecraft.func_71410_x().field_71466_p);
            }
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
            RenderUtils.render16Icon(this.group.getTextureLoc(), this.x + 2, this.y + 2);
        }
    }

    class Scrollbar
    extends BaseScrollbar {
        protected Scrollbar(int xpos, int ypos, int scrollbarTotalHeight) {
            super(xpos, ypos, scrollbarTotalHeight);
        }

        @Override
        protected void applyValue() {
            BestiaryScreen.this.setCurrentElement((int)(this.value * (double)BestiaryScreen.this.elementsAmount));
        }
    }

    class SplitterButton
    extends ImageButton {
        BestiaryEntry.Splitter splitter;

        public SplitterButton(BestiaryEntry.Splitter splitter, int xPos, int yPos) {
            super(xPos, yPos, entryButtonX, entryButtonY, 0, 0, entryButtonY, BestiaryScreen.this.SPLITTER_BUTTON_TEXTURE, button -> {});
            this.splitter = splitter;
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
            int xp = this.x + 10;
            int n = this.y + entryButtonY / 2;
            BestiaryScreen.this.mc.field_71466_p.getClass();
            int yp = n - 9 / 2;
            BestiaryScreen.this.mc.field_71466_p.func_175063_a(this.splitter.splitReason, (float)xp, (float)yp, TextFormatting.YELLOW.func_211163_e().intValue());
        }
    }
}

