/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.main_hub;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.IAlertScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.overlays.bar_overlays.bases.BaseBarsOverlay;
import com.robertx22.mine_and_slash.gui.overlays.bar_overlays.types.BottomMiddleCornersOverlay;
import com.robertx22.mine_and_slash.gui.screens.bestiary.BestiaryScreen;
import com.robertx22.mine_and_slash.gui.screens.map_info_gui.MapInfoScreen;
import com.robertx22.mine_and_slash.gui.screens.spell_hotbar_setup.SpellHotbatSetupScreen;
import com.robertx22.mine_and_slash.gui.screens.spell_schools.SpellSchoolScreen;
import com.robertx22.mine_and_slash.gui.screens.stat_allocation_screen.StatAllocationScreen;
import com.robertx22.mine_and_slash.gui.screens.stats_overview.StatOverviewScreen;
import com.robertx22.mine_and_slash.gui.screens.talent_tree_gui.TalentPerkTreeScreen;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MainHubScreen
extends BaseScreen
implements INamedScreen {
    ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/main_hub/window.png");
    public static ResourceLocation EXLAMATION_MARK_TEX = new ResourceLocation("mmorpg", "textures/gui/main_hub/exclamation_mark.png");
    public Minecraft mc;
    static int x = 318;
    static int y = 232;
    BottomMiddleCornersOverlay overlay = new BottomMiddleCornersOverlay();

    public MainHubScreen() {
        super(x, y);
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    protected void init() {
        super.init();
        ArrayList<Screen> screens = new ArrayList<Screen>();
        screens.add(new MapInfoScreen());
        screens.add(new SpellHotbatSetupScreen());
        screens.add(new StatOverviewScreen());
        screens.add(new StatAllocationScreen());
        screens.add(new SpellSchoolScreen());
        screens.add(new TalentPerkTreeScreen());
        screens.add(new BestiaryScreen());
        int x = this.guiLeft + 10;
        int y = this.guiTop + 45;
        int count = 0;
        for (INamedScreen iNamedScreen : screens) {
            if (count >= 3) {
                y += Button.ySize + 5;
                x = this.guiLeft + 9;
                count = 0;
            }
            if (count >= 1) {
                x += Button.xSize + 5;
            }
            ++count;
            this.addButton((Widget)new Button(iNamedScreen, x, y));
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawBackground(ticks, x, y);
        super.render(x, y, ticks);
        this.renderTitle();
        int expx = this.guiLeft + this.sizeX / 2 - BaseBarsOverlay.BAR_WIDTH / 2;
        int expy = this.guiTop + this.sizeY - BaseBarsOverlay.BAR_HEIGHT - 5;
        this.overlay.DrawBar(BaseBarsOverlay.BarType.EXP, Load.Unit((ICapabilityProvider)this.mc.field_71439_g), expx, expy);
    }

    private void renderTitle() {
        double scale = 1.8f;
        String str = "Main Hub";
        int xp = this.guiLeft + x / 2;
        int yp = this.guiTop + 20;
        GuiUtils.renderScaledText(xp, yp, scale, str, TextFormatting.YELLOW);
    }

    protected void drawBackground(float partialTicks, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BACKGROUND_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MainHubScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)MainHubScreen.x, (int)MainHubScreen.y, (int)256, (int)512);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/map_info.png");
    }

    @Override
    public Words screenName() {
        return Words.MapInfo;
    }

    static class Button
    extends ImageButton {
        public static int xSize = 95;
        public static int ySize = 32;
        boolean shouldAlert = false;
        static ResourceLocation buttonLoc = new ResourceLocation("mmorpg", "textures/gui/main_hub/buttons.png");
        INamedScreen screen;

        public Button(INamedScreen screen, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, buttonLoc, button -> Minecraft.func_71410_x().func_147108_a((Screen)screen));
            this.screen = screen;
            if (screen instanceof IAlertScreen) {
                IAlertScreen alert = (IAlertScreen)((Object)screen);
                this.shouldAlert = alert.shouldAlert();
            }
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
            RenderUtils.render16Icon(this.screen.iconLocation(), this.x + 9, this.y + 7);
            if (this.shouldAlert) {
                RenderUtils.render16Icon(EXLAMATION_MARK_TEX, this.x + 5, this.y + 7);
            }
            String str = this.screen.screenName().translate();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(str, (float)(this.x + 30), (float)(this.y + 10), TextFormatting.GREEN.func_211163_e().intValue());
        }
    }
}

