/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.map_info_gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.main_hub.MainHubScreen;
import com.robertx22.mine_and_slash.items.misc.ItemMap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class MapInfoScreen
extends BaseScreen
implements INamedScreen {
    ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/map_info/window.png");
    public Minecraft mc = Minecraft.func_71410_x();
    static int x = 318;
    static int y = 232;
    int mapX = 0;
    int mapY = 0;
    int questX = 0;
    int questY = 0;
    public static int xSize = 18;
    public static int ySize = 18;
    static ResourceLocation img = new ResourceLocation("");
    static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/back_button.png");

    public MapInfoScreen() {
        super(x, y);
    }

    @Override
    protected void init() {
        super.init();
        this.mapX = this.guiLeft + 57;
        this.mapY = this.guiTop + 165;
        this.questX = this.guiLeft + 246;
        this.questY = this.guiTop + 165;
        this.addButton((Widget)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
        PlayerMapCap.IPlayerMapData data = Load.playerMapData((PlayerEntity)this.mc.field_71439_g);
        if (data.isMapActive()) {
            ArrayList<ITextComponent> questTooltip = new ArrayList<ITextComponent>();
            questTooltip.addAll(data.getMap().getTooltip());
            this.addButton((Widget)new ItemButton(new ItemStack((IItemProvider)ItemMap.Items.getOrDefault(data.getMap().rarity, ItemMap.Items.get(0))), questTooltip, this.mapX, this.mapY));
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawBackground(ticks, x, y);
        super.render(x, y, ticks);
        this.renderTexts();
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    public void renderTexts() {
        FontRenderer font = this.mc.field_71466_p;
        String title = "Current Adventure Map Info";
        GuiUtils.renderScaledText(this.guiLeft + x / 2, this.guiTop + 15, 1.6, title, TextFormatting.YELLOW);
        int y = 20;
        int x = 8;
        GuiUtils.renderScaledText(this.mapX + x, this.mapY - y, 1.5, "Adventure Map", TextFormatting.RED);
        GuiUtils.renderScaledText(this.questX + x, this.questY - y, 1.5, "Quest", TextFormatting.GREEN);
    }

    protected void drawBackground(float partialTicks, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.BACKGROUND_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MapInfoScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)MapInfoScreen.x, (int)MapInfoScreen.y, (int)256, (int)512);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/map_info.png");
    }

    @Override
    public Words screenName() {
        return Words.MapInfo;
    }

    static class BackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainHubScreen()));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    class ItemButton
    extends ImageButton {
        List<ITextComponent> tooltip;
        ItemStack stack;
        ResourceLocation icon;

        public ItemButton(ItemStack stack, List<ITextComponent> tooltip, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, img, button -> {});
            this.stack = stack;
            this.tooltip = tooltip;
        }

        public ItemButton(ResourceLocation icon, List<ITextComponent> tooltip, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, img, button -> {});
            this.icon = icon;
            this.tooltip = tooltip;
        }

        public void renderButton(int x, int y, float ticks) {
            if (this.stack != null) {
                MapInfoScreen.this.mc.func_175599_af().func_180450_b(this.stack, this.x, this.y);
            } else {
                RenderUtils.render16Icon(this.icon, this.x, this.y);
            }
        }

        public void renderToolTip(int x, int y) {
            if (GuiUtils.isInRect(this.x, this.y, xSize, ySize, x, y)) {
                MapInfoScreen.this.renderTooltip(TooltipUtils.compsToStrings(this.tooltip), x, y, Minecraft.func_71410_x().field_71466_p);
            }
        }
    }
}

