/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.spell_hotbar_setup;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.main_hub.MainHubScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.spells.HotbarSetupPacket;
import com.robertx22.mine_and_slash.packets.spells.WeaponRightClickSpellPacket;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class SpellHotbatSetupScreen
extends BaseScreen
implements INamedScreen {
    static ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/hotbar_setup/window.png");
    public Minecraft mc = Minecraft.func_71410_x();
    static int x = 212;
    static int y = 222;
    PlayerSpellCap.ISpellsCap spells;
    public static HotbarButton barBeingPicked = null;
    static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/back_button.png");

    public SpellHotbatSetupScreen() {
        super(x, y);
        this.spells = Load.spells((LivingEntity)this.mc.field_71439_g);
    }

    @Override
    protected void init() {
        super.init();
        List<BaseSpell> spells = this.spells.getAvailableSpells();
        this.addButton((Widget)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
        int x = this.guiLeft + 7;
        int y = this.guiTop + 40;
        int count = 0;
        for (BaseSpell spell : spells) {
            if (spell == null) continue;
            if (count >= 11) {
                y += AvailableSpellButton.ySize + 2;
                x = this.guiLeft + 7;
                count = 0;
            }
            if (count >= 1) {
                x += AvailableSpellButton.xSize + 2;
            }
            ++count;
            this.addButton((Widget)new AvailableSpellButton(spell, x, y));
        }
        count = 0;
        x = this.guiLeft + 55;
        y = this.guiTop + 90;
        HotbarButton right = new HotbarButton(0, SpellCastingData.Hotbar.FIRST, this.guiLeft + SpellHotbatSetupScreen.x / 2 - HotbarButton.xSize / 2, y);
        right.isForRightClickWeaponSpell = true;
        this.addButton((Widget)right);
        for (SpellCastingData.Hotbar bar : Arrays.asList(SpellCastingData.Hotbar.FIRST, SpellCastingData.Hotbar.SECOND)) {
            y += 50;
            x = this.guiLeft + 55;
            for (int i = 0; i < 5; ++i) {
                HotbarButton but = new HotbarButton(i, bar, x, y);
                this.addButton((Widget)but);
                x += HotbarButton.xSize;
            }
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawBackground(ticks, x, y);
        this.drawText();
        super.render(x, y, ticks);
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    private void drawText() {
        double scale = 1.25;
        String str = "Weapon Right Click Spell";
        int xp = this.guiLeft + x / 2;
        int yp = 80 + this.guiTop;
        GuiUtils.renderScaledText(xp, yp, scale, str, TextFormatting.LIGHT_PURPLE);
        str = "First Hotbar";
        xp = this.guiLeft + x / 2;
        yp = 130 + this.guiTop;
        GuiUtils.renderScaledText(xp, yp, scale, str, TextFormatting.GREEN);
        str = "Second Hotbar";
        xp = this.guiLeft + x / 2;
        yp = 180 + this.guiTop;
        GuiUtils.renderScaledText(xp, yp, scale, str, TextFormatting.GREEN);
        str = "Available Spells";
        xp = this.guiLeft + x / 2;
        yp = 12 + this.guiTop;
        GuiUtils.renderScaledText(xp, yp, scale, str, TextFormatting.YELLOW);
    }

    protected void drawBackground(float partialTicks, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SpellHotbatSetupScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)SpellHotbatSetupScreen.x, (int)SpellHotbatSetupScreen.y, (int)256, (int)256);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/spellbar.png");
    }

    @Override
    public Words screenName() {
        return Words.Spellbar;
    }

    static class BackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainHubScreen()));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    static class AvailableSpellButton
    extends ImageButton {
        public static int xSize = 16;
        public static int ySize = 16;
        static ResourceLocation buttonLoc = new ResourceLocation("mmorpg", "textures/gui/main_hub/buttons.png");
        BaseSpell spell;

        public AvailableSpellButton(BaseSpell spell, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {
                if (barBeingPicked != null) {
                    HotbarButton bar = barBeingPicked;
                    if (bar.isForRightClickWeaponSpell) {
                        MMORPG.sendToServer(new WeaponRightClickSpellPacket(spell));
                        WeaponRightClickSpellPacket.activate((PlayerEntity)Minecraft.func_71410_x().field_71439_g, spell.GUID());
                    } else if (bar.hotbar != null) {
                        MMORPG.sendToServer(new HotbarSetupPacket(spell, bar.number, bar.hotbar));
                    }
                }
            });
            this.spell = spell;
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.spell != null && GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                GuiUtils.renderTooltip(this.spell.GetTooltipString(info), mouseX, mouseY);
            }
        }

        public void renderButton(int x, int y, float ticks) {
            if (this.spell != null && this.spell.getIconLoc() != null) {
                RenderUtils.render16Icon(this.spell.getIconLoc(), this.x, this.y);
            }
        }
    }

    static class HotbarButton
    extends ImageButton {
        public static int xSize = 20;
        public static int ySize = 20;
        static ResourceLocation NORMAL_TEX = new ResourceLocation("mmorpg", "textures/gui/hotbar_setup/hotbar_button.png");
        static ResourceLocation PICKED_TEX = new ResourceLocation("mmorpg", "textures/gui/hotbar_setup/picked_bar.png");
        int number;
        SpellCastingData.Hotbar hotbar;
        public boolean isForRightClickWeaponSpell = false;

        public HotbarButton(int number, SpellCastingData.Hotbar hotbar, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {});
            this.hotbar = hotbar;
            this.number = number;
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.getSpell() != null) {
                if (GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                    TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                    GuiUtils.renderTooltip(this.getSpell().GetTooltipString(info), mouseX, mouseY);
                }
            } else if (this.isForRightClickWeaponSpell && GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                ArrayList<ITextComponent> tip = new ArrayList<ITextComponent>();
                tip.add((ITextComponent)new SText(TextFormatting.BLUE + "Some spells can be attached to a weapon as a right click spell."));
                GuiUtils.renderTooltip(tip, mouseX, mouseY);
            }
        }

        public void onPress() {
            super.onPress();
            if (!this.isForRightClickWeaponSpell) {
                if (this.getSpell() != null) {
                    MMORPG.sendToServer(new HotbarSetupPacket(null, this.number, this.hotbar));
                } else {
                    barBeingPicked = this;
                }
            } else if (this.getSpell() != null) {
                MMORPG.sendToServer(new WeaponRightClickSpellPacket(null));
                WeaponRightClickSpellPacket.activate((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "");
            } else {
                barBeingPicked = this;
            }
        }

        @Nullable
        public BaseSpell getSpell() {
            if (this.isForRightClickWeaponSpell) {
                GearItemData gear = Gear.Load(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
                return gear != null ? gear.getRightClickSpell() : null;
            }
            return Load.spells((LivingEntity)Minecraft.func_71410_x().field_71439_g).getCastingData().getSpellByKeybind(this.number, this.hotbar);
        }

        public void renderButton(int x, int y, float ticks) {
            Minecraft mc = Minecraft.func_71410_x();
            if (barBeingPicked == this) {
                mc.func_110434_K().func_110577_a(PICKED_TEX);
            } else {
                mc.func_110434_K().func_110577_a(NORMAL_TEX);
            }
            RenderSystem.disableDepthTest();
            this.blit(this.x, this.y, 0, 0, this.width, this.height);
            RenderSystem.enableDepthTest();
            BaseSpell spell = this.getSpell();
            if (spell != null) {
                RenderUtils.render16Icon(spell.getIconLoc(), this.x + 2, this.y + 2);
            }
        }
    }
}

