/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.spell_schools;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.IAlertScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.main_hub.MainHubScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.allocation.abilities.TryAllocateAbilityPointPacket;
import com.robertx22.mine_and_slash.packets.allocation.abilities.TryRemoveAbilityPointPacket;
import com.robertx22.mine_and_slash.packets.allocation.schools.TryAddSchoolPointPacket;
import com.robertx22.mine_and_slash.packets.allocation.schools.TryRemoveSchoolPointPacket;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.awt.Point;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellSchoolScreen
extends BaseScreen
implements INamedScreen,
IAlertScreen {
    static ResourceLocation BACKGROUND = new ResourceLocation("mmorpg", "textures/gui/spell_schools/background.png");
    static ResourceLocation FOREGROUND = new ResourceLocation("mmorpg", "textures/gui/spell_schools/fore.png");
    static ResourceLocation PICK_BACKGROUND = new ResourceLocation("mmorpg", "textures/gui/spell_schools/pick_background.png");
    static ResourceLocation PARTS = new ResourceLocation("mmorpg", "textures/gui/spell_schools/parts.png");
    static ResourceLocation ABILITY = new ResourceLocation("mmorpg", "textures/gui/spell_schools/ability.png");
    static ResourceLocation SCHOOL_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/school_button.png");
    static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/back_button.png");
    static int X = 246;
    static int Y = 186;
    PlayerSpellCap.ISpellsCap spells;
    EntityCap.UnitData data;
    private Masteries school = null;

    public SpellSchoolScreen() {
        super(X, Y);
    }

    public SpellSchoolScreen(Masteries school) {
        super(X, Y);
        this.school = school;
    }

    public void setSpellSchool(Masteries school) {
        this.school = school;
        this.init();
    }

    @Override
    public void init() {
        this.spells = Load.spells((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        this.data = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
        this.buttons.clear();
        super.init();
        if (this.school != null) {
            this.addButton((Widget)new SchoolButton(this.school, this.guiLeft + 14, this.guiTop + 10));
            this.addButton((Widget)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
            int i = 0;
            for (BasePotionEffect e : SlashRegistry.PotionEffects().getFilterWrapped((Predicate<BasePotionEffect>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$0(com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect ), (Lcom/robertx22/mine_and_slash/potion_effects/bases/BasePotionEffect;)Z)((SpellSchoolScreen)this)).list) {
                if (e.getSpell() != null) continue;
                int xpos = this.guiLeft + 50 + i * (AbilityButton.xSize + 6);
                int ypos = this.guiTop + 157;
                this.addButton((Widget)new AbilityButton(e, xpos, ypos));
                ++i;
            }
            ArrayList list = new ArrayList();
            list.addAll(SlashRegistry.Spells().getFilterWrapped((Predicate<BaseSpell>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$1(com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell ), (Lcom/robertx22/mine_and_slash/database/spells/spell_classes/bases/BaseSpell;)Z)((SpellSchoolScreen)this)).list);
            list.addAll(SlashRegistry.Synergies().getFilterWrapped((Predicate<Synergy>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$2(com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy ), (Lcom/robertx22/mine_and_slash/database/spells/synergies/base/Synergy;)Z)((SpellSchoolScreen)this)).list);
            list.forEach(x -> {
                int xpos = this.guiLeft + 50 + x.getAbilityPlace().x * (AbilityButton.xSize + 6);
                int ypos = this.guiTop + 134 - x.getAbilityPlace().y * (AbilityButton.ySize + 3);
                this.addButton((Widget)new AbilityButton((IAbility)x, xpos, ypos));
            });
        } else {
            int xpos = this.guiLeft + 17;
            int ypos = this.guiTop + 15;
            this.addButton((Widget)new MainBackButton(this.guiLeft, this.guiTop - MainBackButton.ySize));
            for (Masteries value : Masteries.values()) {
                this.addButton((Widget)new PickSchoolButton(this, value, xpos, ypos));
                xpos += PickSchoolButton.xSize + PickSchoolButton.xSize / 8;
            }
        }
    }

    public void render(int x, int y, float ticks) {
        this.drawBackground(ticks, x, y);
        this.buttons.forEach(b -> {
            if (b instanceof AbilityButton) {
                AbilityButton ab = (AbilityButton)((Object)b);
                ab.renderUnder();
            }
        });
        super.render(x, y, ticks);
        Minecraft mc = Minecraft.func_71410_x();
        if (this.school != null) {
            String str = "Skill Points: " + this.spells.getAbilitiesData().getFreeAbilityPoints(this.data);
            int xp = this.guiLeft + 5;
            int yp = this.guiTop + Y + 5;
            mc.field_71466_p.func_175063_a(str, (float)xp, (float)yp, TextFormatting.GREEN.func_211163_e().intValue());
            str = "Reset Points: " + this.spells.getAbilitiesData().resetPoints;
            xp = this.guiLeft + X - mc.field_71466_p.func_78256_a(str);
            yp = this.guiTop + Y + 5;
            mc.field_71466_p.func_175063_a(str, (float)xp, (float)yp, TextFormatting.LIGHT_PURPLE.func_211163_e().intValue());
        }
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    protected void drawBackground(float partialTicks, int x, int y) {
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PICK_BACKGROUND);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SpellSchoolScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)X, (int)Y, (int)256, (int)256);
        if (this.school != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(FOREGROUND);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SpellSchoolScreen.blit((int)(this.guiLeft + 7), (int)(this.guiTop + 7), (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)X, (int)Y, (int)256, (int)256);
        }
        RenderSystem.disableBlend();
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/spells.png");
    }

    @Override
    public Words screenName() {
        return Words.Spells;
    }

    @Override
    public boolean shouldAlert() {
        try {
            return Load.spells((LivingEntity)Minecraft.func_71410_x().field_71439_g).getAbilitiesData().getFreeAbilityPoints(Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g)) > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private /* synthetic */ boolean lambda$init$2(Synergy x) {
        return x.getMastery().equals((Object)this.school);
    }

    private /* synthetic */ boolean lambda$init$1(BaseSpell x) {
        return x.getMastery().equals((Object)this.school);
    }

    private /* synthetic */ boolean lambda$init$0(BasePotionEffect x) {
        return x.getMastery().equals((Object)this.school);
    }

    static class SchoolButton
    extends ImageButton {
        public static int xSize = 22;
        public static int ySize = 161;
        Masteries school;
        EntityCap.UnitData data;
        PlayerSpellCap.ISpellsCap spells;

        public SchoolButton(Masteries school, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {});
            this.school = school;
            this.data = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
            this.spells = Load.spells((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                this.school.getStatsFor(this.spells.getAbilitiesData().getSchoolPoints(this.school), this.data).forEach(x -> list.addAll(x.GetTooltipString(info)));
                if (this.school.getEffectiveLevel(this.spells) > this.data.getLevel()) {
                    list.add((ITextComponent)new SText(TextFormatting.RED + "WARNING: Additional points will not provide bonus stats!"));
                    list.add((ITextComponent)new SText(TextFormatting.RED + "Effective stat bonus is capped based on player level."));
                }
                if (this.data.getLevel() < Masteries.LVL_TO_UNLOCK_2ND_SCHOOL) {
                    list.add((ITextComponent)new SText(TextFormatting.GOLD + "You unlock a second school of magic at level " + Masteries.LVL_TO_UNLOCK_2ND_SCHOOL + "."));
                }
                TooltipUtils.abilityLevel(list, this.spells.getAbilitiesData().getSchoolPoints(this.school), Masteries.MAXIMUM_POINTS);
                GuiUtils.renderTooltip(list, mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double x, double y, int click) {
            if (this.active && this.visible && this.isHovered()) {
                if (click == 1) {
                    MMORPG.sendToServer(new TryRemoveSchoolPointPacket(this.school));
                } else {
                    MMORPG.sendToServer(new TryAddSchoolPointPacket(this.school));
                }
            }
            return super.mouseClicked(x, y, click);
        }

        public void renderButton(int x, int y, float ticks) {
            float filled = (float)this.spells.getAbilitiesData().getSchoolPoints(this.school) / (float)Masteries.MAXIMUM_POINTS;
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(SCHOOL_BUTTON);
            int offx = this.school.getBarTexXOffset();
            int offy = 0;
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            this.blit(this.x, this.y, 0, 0, this.width, this.height);
            int fillY = (int)((float)this.y + (1.0f - filled) * (float)(ySize - 22));
            this.blit(this.x + 1, fillY, offx, offy, this.width - 1, (int)((float)(this.height - 22) * filled));
            this.blit(this.x, this.y, xSize + 1, 0, this.width, this.height);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    static class MainBackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public MainBackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainHubScreen()));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    static class BackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new SpellSchoolScreen(null)));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    static class PickSchoolButton
    extends ImageButton {
        public static int xSize = 32;
        public static int ySize = 32;
        Masteries school;
        EntityCap.UnitData data;
        SpellSchoolScreen screen;

        public PickSchoolButton(SpellSchoolScreen screen, Masteries school, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {});
            this.screen = screen;
            this.school = school;
            this.data = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.school != null && GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                List<ITextComponent> tooltip = TooltipUtils.cutIfTooLong(this.school.desc.locName());
                tooltip.forEach(x -> x.func_211708_a(this.school.format));
                GuiUtils.renderTooltip(tooltip, mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double x, double y, int click) {
            if (this.active && this.visible && this.isHovered()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new SpellSchoolScreen(this.school));
                return true;
            }
            return super.mouseClicked(x, y, click);
        }

        public void renderButton(int x, int y, float ticks) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(this.school.getGuiIconLocation());
            boolean offx = false;
            boolean offy = false;
            RenderSystem.disableDepthTest();
            PickSchoolButton.blit((int)this.x, (int)this.y, (float)((float)offx), (float)((float)offy), (int)this.width, (int)this.height, (int)xSize, (int)ySize);
            RenderSystem.enableDepthTest();
            String str = this.school.locName.translate();
            int xp = this.x + xSize / 2 - mc.field_71466_p.func_78256_a(str) / 2;
            mc.field_71466_p.getClass();
            int yp = this.y + ySize + 9 / 2;
            mc.field_71466_p.func_175063_a(str, (float)xp, (float)yp, this.school.format.func_211163_e().intValue());
        }
    }

    static class AbilityButton
    extends ImageButton {
        public static int xSize = 18;
        public static int ySize = 18;
        IAbility ability;
        EntityCap.UnitData data;
        PlayerSpellCap.ISpellsCap spells;

        public AbilityButton(IAbility ability, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {});
            this.ability = ability;
            this.data = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
            this.spells = Load.spells((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.ability != null && GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                GuiUtils.renderTooltip(this.ability.GetTooltipString(info), mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double x, double y, int click) {
            if (this.active && this.visible && this.isHovered()) {
                if (click == 1) {
                    MMORPG.sendToServer(new TryRemoveAbilityPointPacket(this.ability));
                } else {
                    MMORPG.sendToServer(new TryAllocateAbilityPointPacket(this.ability));
                }
            }
            return super.mouseClicked(x, y, click);
        }

        public void renderUnder() {
            if (this.ability.getAbilityType().equals((Object)IAbility.Type.SYNERGY)) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(ABILITY);
                this.blit(this.x + xSize / 2 - 3, this.y + ySize / 2, 136, 0, 6, 21);
            }
        }

        public void renderButton(int x, int y, float ticks) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(ABILITY);
            int offx = 0;
            int offy = 0;
            if (this.ability.getAbilityType().equals((Object)IAbility.Type.SPELL)) {
                offx = 19;
            }
            if (this.spells.getAbilitiesData().getFreeAbilityPoints(this.data) > 0 && this.spells.getLevelOf(this.ability) < 1 && !this.spells.getAbilitiesData().canAddPointsOrHasPoints(this.ability, this.data)) {
                offy = 19;
            }
            RenderSystem.disableDepthTest();
            this.blit(this.x, this.y, offx, offy, this.width, this.height);
            RenderSystem.enableDepthTest();
            if (this.ability != null) {
                float s = 0.5f;
                float as = 1.0f / s;
                RenderSystem.scalef((float)s, (float)s, (float)s);
                RenderUtils.render32Icon(this.ability.getIconLoc(), (int)((float)(this.x + 5) * as), (int)((float)(this.y + 5) * as));
                RenderSystem.scalef((float)as, (float)as, (float)as);
                String str = this.spells.getLevelOf(this.ability) + "/" + this.ability.getMaxSpellLevelNormal();
                int xp = this.x + xSize / 2;
                int yp = this.y + xSize - 2;
                GuiUtils.renderScaledText(xp, yp, 0.75, str, this.ability.getMastery().format);
            }
        }
    }
}

