/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.stat_allocation_screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.base.BaseCoreStat;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.IAlertScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.main_hub.MainHubScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.allocation.stats.SpendStatPointPacket;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.RequestSyncCapToClient;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.SingleStatPointData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerStatsPointsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class StatAllocationScreen
extends BaseScreen
implements INamedScreen,
IAlertScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mmorpg", "textures/gui/stat_point_screen.png");
    static int sizeY = 220;
    static int sizeX = 215;
    PlayerStatsPointsCap.IPlayerStatPointsData data;
    EntityCap.UnitData unitdata;
    int guiLeft = 0;
    int guiTop = 0;
    private static final ResourceLocation BUTTON_TEX = new ResourceLocation("mmorpg", "textures/gui/button.png");
    static int button_sizeX = 13;
    static int button_sizeY = 13;
    static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spell_schools/back_button.png");

    public StatAllocationScreen() {
        super(sizeX, sizeY);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/stat_points.png");
    }

    public boolean mouseReleased(double x, double y, int ticks) {
        this.buttons.forEach(b -> {
            if (GuiUtils.isInRectPoints(new Point(b.x, b.y), new Point(b.getWidth(), b.getHeight()), new Point((int)x, (int)y))) {
                b.onClick(x, y);
            }
        });
        return super.mouseReleased(x, y, ticks);
    }

    @Override
    public Words screenName() {
        return Words.StatPoints;
    }

    @Override
    protected void init() {
        super.init();
        MMORPG.sendToServer(new RequestSyncCapToClient(PlayerCaps.STAT_POINTS));
        this.data = Load.statPoints((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.unitdata = Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g);
        if (this.data == null || this.unitdata == null) {
            this.onClose();
            return;
        }
        this.guiLeft = (this.width - sizeX) / 2;
        this.guiTop = (this.height - sizeY) / 2;
        int y = 0;
        for (SingleStatPointData single : this.data.getData().getAllStatDatas()) {
            this.buttons.add(new IncreaseStatButton(this.unitdata, this.data, single, this.guiLeft + sizeX / 2 + 50, this.guiTop + 40 + y));
            y += button_sizeY + 3;
        }
        this.addButton((Widget)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
    }

    public void render(int x, int y, float ticks) {
        this.drawGuiBackgroundLayer(ticks, x, y);
        super.render(x, y, ticks);
        String str = "Stat Points Remaining: " + this.data.getAvailablePoints(Load.Unit((ICapabilityProvider)this.minecraft.field_71439_g));
        Minecraft.func_71410_x().field_71466_p.func_175063_a(str, (float)(this.guiLeft + sizeX / 2 + 50 - Minecraft.func_71410_x().field_71466_p.func_78256_a(str)), (float)(this.guiTop + 15), TextFormatting.GREEN.func_211163_e().intValue());
        this.buttons.forEach(b -> b.renderToolTip(x, y));
    }

    protected void drawGuiBackgroundLayer(float partialTicks, int x, int y) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.minecraft.field_195558_d.func_198107_o() / 2 - sizeX / 2, this.minecraft.field_195558_d.func_198087_p() / 2 - sizeY / 2, 0, 0, sizeX, sizeY);
    }

    @Override
    public boolean shouldAlert() {
        try {
            return Load.statPoints((PlayerEntity)Minecraft.func_71410_x().field_71439_g).getAvailablePoints(Load.Unit((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g)) > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static class BackButton
    extends ImageButton {
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainHubScreen()));
        }

        public void renderButton(int x, int y, float ticks) {
            super.renderButton(x, y, ticks);
        }
    }

    class IncreaseStatButton
    extends ImageButton {
        FontRenderer font;
        PlayerStatsPointsCap.IPlayerStatPointsData data;
        LvlPointStat stat;
        EntityCap.UnitData unitdata;

        public IncreaseStatButton(EntityCap.UnitData unitdata, PlayerStatsPointsCap.IPlayerStatPointsData data, SingleStatPointData statData, int xPos, int yPos) {
            super(xPos, yPos, button_sizeX, button_sizeY, 0, 0, button_sizeY, BUTTON_TEX, button -> {});
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.data = data;
            this.stat = statData.stat;
            this.unitdata = unitdata;
        }

        public void onPress() {
            super.onPress();
            MMORPG.sendToServer(new SpendStatPointPacket(this.stat));
            MMORPG.sendToServer(new RequestSyncCapToClient(PlayerCaps.STAT_POINTS));
        }

        public void renderToolTip(int x, int y) {
            if (this.isInside(x, y)) {
                Stat stat = SlashRegistry.Stats().get(this.stat.statguid);
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                tooltip.add(Styles.BLUECOMP().func_150257_a(stat.locName()));
                if (stat instanceof BaseCoreStat) {
                    BaseCoreStat core = (BaseCoreStat)stat;
                    tooltip.addAll(core.getCoreStatTooltip(this.unitdata, this.unitdata.getUnit().getCreateStat(stat)));
                }
                StatAllocationScreen.this.renderTooltip(TooltipUtils.compsToStrings(tooltip), x, y, Minecraft.func_71410_x().field_71466_p);
            }
        }

        public boolean isInside(int x, int y) {
            return GuiUtils.isInRect(this.x, this.y, button_sizeX, button_sizeY, x, y);
        }

        public void renderButton(int x, int y, float f) {
            try {
                super.renderButton(x, y, f);
                TextFormatting format = TextFormatting.YELLOW;
                SingleStatPointData single = this.data.getStatData(this.stat);
                Stat stat = single.getStat();
                String str = single.stat.formatting + single.stat.shortName + format + ": " + TextFormatting.GREEN + single.points + format;
                str = str + ", Current(" + TextFormatting.GREEN + (int)this.unitdata.getUnit().getCreateStat(stat).getAverageValue() + format + ")";
                float f2 = this.x - button_sizeX - 5 - this.font.func_78256_a(str);
                int n = this.y - button_sizeY / 2;
                this.font.getClass();
                this.font.func_175063_a(str, f2, (float)(n + 9), format.func_211163_e().intValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

