/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.trader;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.new_content.trader.TraderData;
import com.robertx22.mine_and_slash.new_content.trader.TraderEntity;
import com.robertx22.mine_and_slash.packets.trader.BuyTraderItemPacket;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GuiUtils;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TraderScreen
extends BaseScreen {
    public TraderData data;
    public int traderID;
    private static final ResourceLocation texture = new ResourceLocation("mmorpg", "textures/gui/trader.png");
    public static int xSize = 16;
    public static int ySize = 16;
    static ResourceLocation BUTTON_TEX = new ResourceLocation("mmorpg", "textures/gui/hotbar_setup/hotbar_button.png");

    public TraderScreen(TraderData data, int traderID) {
        super(176, 92);
        this.traderID = traderID;
        this.data = data;
        Preconditions.checkArgument((data.stacks.size() < 28 ? 1 : 0) != 0);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        super.render(mouseX, mouseY, partialTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void init() {
        super.init();
        this.buttons.clear();
        int i = 0;
        for (int xpos = 0; xpos < 3; ++xpos) {
            for (int ypos = 0; ypos < 9; ++ypos) {
                if (this.data.stacks.size() <= i) continue;
                int x = this.guiLeft + 8 + ypos * 18;
                int y = this.guiTop + 18 + xpos * 18;
                this.addButton((Widget)new SoldItemButton(i, this.data.stacks.get(i), this.traderID, x, y));
                ++i;
            }
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        this.buttons.forEach(x -> x.renderToolTip(mouseX, mouseY));
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        int x = (this.width - this.sizeX) / 2;
        int y = (this.height - this.sizeY) / 2;
        this.blit(x, y, 0, 0, this.sizeX, this.sizeY);
    }

    class SoldItemButton
    extends ImageButton {
        ItemStack stack;
        int traderID;
        int number;

        public SoldItemButton(int number, ItemStack stack, int traderID, int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, new ResourceLocation(""), button -> {});
            this.number = number;
            this.traderID = traderID;
            this.stack = stack;
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (!this.stack.func_190926_b() && GuiUtils.isInRectPoints(new Point(this.x, this.y), new Point(xSize, ySize), new Point(mouseX, mouseY))) {
                TraderScreen.this.renderTooltip(this.stack, mouseX, mouseY);
            }
        }

        public void onPress() {
            super.onPress();
            try {
                MMORPG.sendToServer(new BuyTraderItemPacket(this.number, (TraderEntity)Minecraft.func_71410_x().field_71441_e.func_73045_a(this.traderID)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void renderButton(int x, int y, float ticks) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(BUTTON_TEX);
            RenderSystem.disableDepthTest();
            RenderSystem.enableDepthTest();
            if (!this.stack.func_190926_b()) {
                Minecraft.func_71410_x().func_175599_af().func_180450_b(this.stack, this.x, this.y);
            }
        }
    }
}

