/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.bags;

import com.robertx22.mine_and_slash.a_libraries.curios.interfaces.ISalvageBag;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.CreativeTabs;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AutoSalvageBag
extends Item
implements ISalvageBag,
IAutoLocName,
IAutoLocMultiLore {
    public static HashMap<Integer, Item> Items = new HashMap();
    public int field_208075_l = 0;
    private final int defaul_gear_rarity_salvage = 0;
    private final int default_map_rarity_salvage = -1;
    private final int default_rune_rarity_salvage = 1;
    private List<Float> BonusSalvageValues = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.5f), Float.valueOf(5.0f), Float.valueOf(10.0f), Float.valueOf(15.0f), Float.valueOf(20.0f), Float.valueOf(25.0f));

    public AutoSalvageBag(int rarity) {
        super(new Item.Properties().func_200916_a(CreativeTabs.MyModTab));
        this.field_208075_l = rarity;
        RegisterItemUtils.RegisterItemName(this, "auto_salvage_bag" + rarity);
    }

    public float getBonusSalvageChance() {
        return this.BonusSalvageValues.get(this.field_208075_l).floatValue();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            ItemStack stack;
            ItemStack bag = player.func_184586_b(hand);
            CompoundNBT nbt = bag.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((stack = player.func_184592_cb()) == null || stack.func_190926_b()) {
                for (DataItemType type : DataItemType.values()) {
                    nbt.func_74768_a(type.nbtGUID, -1);
                }
                player.func_145747_a((ITextComponent)new StringTextComponent("Bag Config Cleared"));
            } else {
                ICommonDataItem data = ICommonDataItem.load(stack);
                if (data != null) {
                    nbt.func_74768_a(data.getDataType().nbtGUID, data.getRarityRank());
                    this.successChat(player);
                }
            }
            bag.func_77982_d(nbt);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    private void successChat(PlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("You Have Successfully Modified your Automatic Salvaging Bag."));
    }

    public ItemStack getSalvageResultForItem(ISalvagable sal) {
        float salvageBonus = this.getBonusSalvageChance();
        return sal.getSalvageResult(salvageBonus);
    }

    public static ISalvagable getSalvagable(ItemStack st) {
        ICommonDataItem data = ICommonDataItem.load(st);
        if (data != null && data.isSalvagable(ISalvagable.SalvageContext.AUTO_SALVAGE_BAG)) {
            return data;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Automatically_salvages_items.locName()).func_150258_a("!"));
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(Styles.YELLOWCOMP().func_150257_a(Words.Gears.locName().func_150258_a(":")));
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Gears.getAllRarities()), this.getGear(nbt)));
        tooltip.add(Styles.YELLOWCOMP().func_150257_a(Words.Maps.locName().func_150258_a(":")));
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Maps.getAllRarities()), this.getMap(nbt)));
        tooltip.add(Styles.YELLOWCOMP().func_150257_a(Words.Runes.locName().func_150258_a(":")));
        tooltip.add(this.getSalvagedRarities(new ArrayList<Rarity>(Rarities.Runes.getAllRarities()), this.getRune(nbt)));
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(Styles.LIGHT_PURPLECOMP().func_150257_a(Words.Bonus_Salvage_Chance.locName()).func_150258_a(": " + this.getBonusSalvageChance() + "%"));
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Works_when_equipped.locName()));
        TooltipUtils.addEmpty(tooltip);
        if (!Screen.hasShiftDown()) {
            tooltip.add(Styles.GREENCOMP().func_150257_a(Words.Press_Shift_For_Setup_Info.locName()));
        } else {
            for (ITextComponent lore : this.getComponents()) {
                tooltip.add(Styles.GREENCOMP().func_150257_a(lore));
            }
        }
    }

    public ITextComponent getSalvagedRarities(List<Rarity> rarities, int rarity) {
        StringTextComponent text = new StringTextComponent("");
        for (GearRarity rar : Rarities.Gears.getNormalRarities()) {
            if (rar.Rank() > rarity) continue;
            if (text.func_150253_a().size() > 0) {
                text.func_150258_a(TextFormatting.GRAY + ", ");
            }
            text.func_150258_a(rar.textFormatting() + "").func_150257_a(rar.locName());
        }
        if (text.func_150253_a().size() < 1) {
            text.func_150257_a(Words.None.locName());
        }
        return text;
    }

    public boolean shouldSalvageItem(ISalvagable sal, CompoundNBT nbt) {
        int rarity = sal.getRarityRank();
        return sal.isSalvagable(ISalvagable.SalvageContext.AUTO_SALVAGE_BAG) && (sal instanceof GearItemData ? rarity <= this.getGear(nbt) : (sal instanceof MapItemData ? rarity <= this.getMap(nbt) : sal instanceof RuneItemData && rarity <= this.getRune(nbt)));
    }

    private int getGear(CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("gear")) {
            return nbt.func_74762_e("gear");
        }
        return this.defaul_gear_rarity_salvage;
    }

    private int getRune(CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("rune")) {
            return nbt.func_74762_e("rune");
        }
        return this.default_rune_rarity_salvage;
    }

    private int getMap(CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("map")) {
            return nbt.func_74762_e("map");
        }
        return this.default_map_rarity_salvage;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locLoresGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Place An Item Of Maximum Rarity You want to", "salvage in your off-hand.", "Then right click with this bag.", "To Not Salvage Any Items, clear the config by", "Right Clicking the bag while shield slot is empty.");
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public String locNameForLangFile() {
        return ((GearRarity)Rarities.Gears.get(this.field_208075_l)).Color() + "Auto Salvage Bag";
    }

    @Override
    public String GUID() {
        return "auto_salvage_bag";
    }

    @Override
    public String locMultiLoreLangFileGUID() {
        return "mmorpg.auto_salvage_bag";
    }
}

