/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.misc;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.AwakenRuneWordLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.runewords.RuneWord;
import com.robertx22.mine_and_slash.items.ItemDefault;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.rune.RuneWordData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;

public class ItemAwakenRuneWord
extends Item
implements ICurrencyItemEffect {
    @ObjectHolder(value="mmorpg:awaken_runeword")
    public static final Item ITEM = null;

    public ItemAwakenRuneWord() {
        super((Item.Properties)new ItemDefault());
        RegisterItemUtils.RegisterItemName(this, "awaken_runeword");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        RuneWord runeword = null;
        try {
            String word = this.getWord(stack);
            runeword = SlashRegistry.RuneWords().get(word);
        }
        catch (Exception e) {
            return super.func_200295_i(stack);
        }
        return super.func_200295_i(stack).func_150258_a(": ").func_150257_a(runeword.locName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack != null && SlashRegistry.RuneWords().isRegistered(this.getWord(stack))) {
            String word = this.getWord(stack);
            RuneWord runeword = SlashRegistry.RuneWords().get(word);
            ITextComponent name = new StringTextComponent(TextFormatting.LIGHT_PURPLE + "").func_150257_a(runeword.locName());
            tooltip.add(Styles.GOLDCOMP().func_150257_a(Words.Runeword.locName().func_150258_a(": ").func_150257_a(name)));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(Styles.REDCOMP().func_150257_a(Words.NeedsGearWithRunesInserted.locName()).func_150258_a(": "));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(runeword.getRuneWordComboString());
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(new StringTextComponent(TextFormatting.AQUA + "").func_150257_a(Words.RunesNeeded.locName()).func_150258_a(": " + runeword.size()));
            TooltipUtils.addEmpty(tooltip);
            try {
                RuneWordData data = new RuneWordData();
                data.name = word;
                data.Mods = runeword.mods().stream().map(x -> StatModData.Load(x, 100)).collect(Collectors.toList());
                TooltipInfo info = new TooltipInfo();
                info.level = 1;
                info.unitdata = new EntityCap.DefaultImpl();
                info.minmax = new MinMax(0, 100);
                tooltip.addAll(data.GetTooltipString(info));
                tooltip.add((ITextComponent)new SText(""));
                tooltip.add((ITextComponent)new SText(TextFormatting.GOLD + "The stats scale to average level and stats-"));
                tooltip.add((ITextComponent)new SText(TextFormatting.GOLD + "of the runes used to create the runeword."));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TooltipUtils.addEmpty(tooltip);
        }
        tooltip.add(Styles.BLUECOMP().func_150257_a(Words.Item_modifiable_in_station.locName()));
        tooltip.add(Styles.BLUECOMP().func_150257_a(Words.unlocks_runeword_combo.locName()));
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack currency) {
        GearItemData gear;
        if (currency.func_77973_b() instanceof ItemAwakenRuneWord && (gear = Gear.Load(stack)) != null) {
            gear.runes.AwakenRuneWord(this.getWord(currency));
            Gear.Save(stack, gear);
        }
        return stack;
    }

    public void setWord(ItemStack stack, RuneWord word) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74778_a("runeword", word.GUID());
        stack.func_77982_d(nbt);
    }

    public String getWord(ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("runeword")) {
            return stack.func_77978_p().func_74779_i("runeword");
        }
        return "";
    }

    @Override
    public final boolean canItemBeModified(LocReqContext context) {
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(AwakenRuneWordLocReq.INSTANCE);
    }
}

