/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.items.misc;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.CreativeTabs;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.BaseItem;
import com.robertx22.mine_and_slash.items.ItemDefault;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RunedGearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.CompatibleItemLootGen;
import com.robertx22.mine_and_slash.loot.gens.util.GearCreationUtils;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemLootbox
extends BaseItem
implements IWeighted,
IAutoLocName {
    public static HashMap<String, ItemLootbox> Items = new HashMap();
    private static HashMap<LootBoxSizes, Integer> ItemAmount = new HashMap<LootBoxSizes, Integer>(){
        {
            this.put(LootBoxSizes.Small, 2);
            this.put(LootBoxSizes.Medium, 4);
            this.put(LootBoxSizes.Big, 6);
        }
    };
    public int weight = 1;
    public LootBoxSizes size;
    public int field_208075_l;
    public LootTypes lootType;

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Lootboxes;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public String locNameForLangFile() {
        return ((GearRarity)Rarities.Gears.get(this.field_208075_l)).textFormatting() + ((GearRarity)Rarities.Gears.get(this.field_208075_l)).locNameForLangFile() + " " + this.size.name() + " " + this.lootType.name() + " Treasure Box";
    }

    @Override
    public String GUID() {
        return this.getRegistryName().toString();
    }

    public static Item GetItem(int rarity, LootTypes type, LootBoxSizes size) {
        String key = ItemLootbox.GetStringForType(rarity, type, size);
        if (Items.containsKey(key)) {
            return Items.get(key);
        }
        return null;
    }

    public static String GetStringForType(int rarity, LootTypes type, LootBoxSizes size) {
        String reg = "lootbox/" + size.toString() + "_" + type.toString() + "_lootbox_" + rarity;
        return reg.toLowerCase(Locale.ROOT);
    }

    public ItemLootbox(LootBoxSizes size, LootTypes type, int rarity) {
        super(new ItemDefault().func_200916_a(CreativeTabs.LootBoxes));
        this.size = size;
        this.field_208075_l = rarity;
        this.lootType = type;
        this.setWeight();
    }

    private void setWeight() {
        int base = ((GearRarity)Rarities.Gears.get(this.field_208075_l)).Weight() + 5000;
        this.weight = base = (int)((float)base * this.size.weightMult);
    }

    private GearType getRandomType() {
        ArrayList<GenWeight> types = new ArrayList<GenWeight>();
        if (((Boolean)ModConfig.INSTANCE.Server.USE_COMPATIBILITY_ITEMS.get()).booleanValue()) {
            types.add(new GenWeight(GearType.Compatible, (int)((Double)ModConfig.INSTANCE.DropRates.COMPATIBLE_ITEMS_DROPRATE.get()).floatValue() * 100));
        }
        types.add(new GenWeight(GearType.Runed, (int)((Double)ModConfig.INSTANCE.DropRates.RUNED_GEAR_DROPRATE.get()).floatValue() * 100));
        types.add(new GenWeight(GearType.Normal, (int)((Double)ModConfig.INSTANCE.DropRates.GEAR_DROPRATE.get()).floatValue() * 100));
        GenWeight winner = (GenWeight)RandomUtils.weightedRandom(types);
        return winner.gen;
    }

    private void GiveItems(PlayerEntity player, int lvl) {
        int i;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.lootType.equals((Object)LootTypes.Gear)) {
            i = 0;
            while (true) {
                if (i < ItemAmount.get((Object)this.size)) {
                    GearBlueprint print;
                    GearType type = this.getRandomType();
                    if (type.equals((Object)GearType.Compatible)) {
                        stacks.add(CompatibleItemLootGen.gen(lvl));
                    } else if (type.equals((Object)GearType.Runed)) {
                        print = new RunedGearBlueprint(lvl);
                        print.rarity.minRarity = this.field_208075_l;
                        print.level.LevelRange = false;
                        stacks.add(GearCreationUtils.CreateStack(print, GearItemEnum.RUNED));
                    } else {
                        print = new GearBlueprint(lvl);
                        print.rarity.minRarity = this.field_208075_l;
                        print.level.LevelRange = false;
                        stacks.add(GearCreationUtils.CreateStack(print));
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if (this.lootType.equals((Object)LootTypes.Currency)) {
            i = 0;
            while (true) {
                if (i >= ItemAmount.get((Object)this.size) + this.field_208075_l) break;
                CurrencyItem item = SlashRegistry.CurrencyItems().random();
                stacks.add(new ItemStack((IItemProvider)item));
                ++i;
            }
        }
        for (ItemStack stack : stacks) {
            player.func_71019_a(stack, false);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        FireworkRocketEntity firework = new FireworkRocketEntity(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, ItemStack.field_190927_a);
        firework.func_70107_b(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
        WorldUtils.spawnEntity(worldIn, (Entity)firework);
        if (!worldIn.field_72995_K) {
            try {
                EntityCap.UnitData data = Load.Unit((ICapabilityProvider)playerIn);
                if (data != null) {
                    int lvl = data.getLevel();
                    this.GiveItems(playerIn, lvl);
                    playerIn.func_184586_b(handIn).func_190918_g(1);
                    return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public String Name() {
        return "LootBox";
    }

    @Override
    public int Weight() {
        return this.weight;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Styles.GREENCOMP().func_150257_a(CLOC.tooltip("lootbox")));
    }

    static class GenWeight
    implements IWeighted {
        GearType gen = GearType.Normal;
        int weight = 1;

        public GenWeight(GearType gen, int weight) {
            this.gen = gen;
            this.weight = weight;
        }

        @Override
        public int Weight() {
            return this.weight;
        }
    }

    public static enum GearType {
        Runed,
        Normal,
        Compatible;

    }

    public static enum LootBoxSizes {
        Small(2.0f),
        Medium(1.0f),
        Big(0.3f);

        float weightMult;

        private LootBoxSizes(float mult) {
            this.weightMult = mult;
        }
    }

    public static enum LootTypes {
        Gear,
        Currency;

    }
}

