/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.mine_and_slash.database.stats.types.generated.LootTypeBonus;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LootInfo {
    public int amount = 0;
    public int tier = 0;
    public int level = 1;
    public EntityCap.UnitData mobData;
    public EntityCap.UnitData playerData;
    public LivingEntity victim;
    public PlayerEntity killer;
    public World world;
    public WorldMapCap.IWorldMapData mapData;
    public float multi = 1.0f;
    public int minItems = 0;
    public int maxItems = 50;
    public boolean isMapWorld = false;
    public BlockPos pos;

    public LootInfo setMaximum(int max) {
        this.maxItems = max;
        return this;
    }

    public LootInfo setMinimum(int min) {
        this.minItems = min;
        return this;
    }

    public LootInfo setLevel(int level) {
        this.level = level;
        return this;
    }

    public LootInfo setMulti(float multi) {
        this.multi = multi;
        return this;
    }

    public LootInfo(EntityCap.UnitData mobData, EntityCap.UnitData playerData, LivingEntity victim, PlayerEntity killer) {
        this.world = victim.field_70170_p;
        this.mobData = mobData;
        this.playerData = playerData;
        this.victim = victim;
        this.killer = killer;
        this.pos = victim.func_180425_c();
        this.setupAllFields();
    }

    public LootInfo(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.setupAllFields();
    }

    public LootInfo(PlayerEntity player) {
        this.world = player.field_70170_p;
        this.playerData = Load.Unit((ICapabilityProvider)player);
        this.pos = player.func_180425_c();
        this.setupAllFields();
    }

    private void setupAllFields() {
        this.errorIfClient();
        this.setWorld();
        this.setTier();
        this.setLevel();
    }

    private LootInfo setTier() {
        if (this.mobData != null) {
            this.tier = this.mobData.getTier();
        } else if (this.world != null && this.mapData != null) {
            if (WorldUtils.isMapWorld((IWorld)this.world)) {
                this.tier = WorldUtils.getTier(this.world, this.mapData, this.pos);
            }
        } else if (this.world != null) {
            this.tier = WorldUtils.getWorldTier(this.world, this.pos);
        }
        return this;
    }

    private void errorIfClient() {
        if (this.world != null && this.world.field_72995_K) {
            throw new RuntimeException("Can't use Loot Info on client side!!!");
        }
    }

    private void setWorld() {
        if (this.world != null) {
            this.isMapWorld = WorldUtils.isMapWorld((IWorld)this.world);
            this.mapData = Load.world(this.world);
        }
    }

    private void setLevel() {
        this.level = WorldUtils.isMapWorldClass((IWorld)this.world) ? (this.mapData != null ? this.mapData.getLevel(this.pos, (IWorld)this.world) : 1) : (this.mobData != null ? this.mobData.getLevel() : (this.playerData != null ? this.playerData.getLevel() : LevelUtils.determineLevel(this.world, this.pos, this.killer)));
    }

    public void setup(BaseLootGen gen) {
        float chance = gen.baseDropChance();
        chance *= this.multi;
        if (this.victim != null && this.mobData != null) {
            chance = (float)((double)chance * SlashRegistry.getEntityConfig((LivingEntity)this.victim, (EntityCap.UnitData)this.mobData).LOOT_MULTI);
        }
        if (this.playerData != null) {
            chance *= this.playerData.getUnit().getCreateStat(new LootTypeBonus(gen.lootType())).getMultiplier();
            chance *= this.playerData.getUnit().getCreateStat(new LootTypeBonus(LootType.All)).getMultiplier();
            if (this.mobData != null && this.playerData.getLevel() < 5 && this.mobData.getLevel() < 5) {
                chance *= 2.0f;
            }
        }
        if (this.killer != null) {
            chance *= Load.playerMapData(this.killer).getLootMultiplier(this.killer);
        }
        if (this.world != null) {
            if (this.victim != null) {
                chance *= Load.antiMobFarm(this.world).getDropMultiForMob(this.victim);
            }
            chance *= SlashRegistry.getDimensionConfig((IWorld)this.world).DROP_MULTIPLIER;
            if (this.world.func_201675_m() instanceof IWP) {
                IWP iwp = (IWP)this.world.func_201675_m();
                chance *= iwp.getBonusLootMulti();
            }
        }
        if (this.mapData != null && this.mapData.getData().hasData(this.pos)) {
            chance *= this.mapData.getLootMultiplier(this.pos, (IWorld)this.world);
        }
        if (this.mobData != null && this.victim != null) {
            chance = LootUtils.applyLootMultipliers(chance, this.mobData, this.victim);
        }
        if (this.mobData != null && this.playerData != null && gen.hasLevelDistancePunishment()) {
            chance = LootUtils.ApplyLevelDistancePunishment(this.mobData, this.playerData, chance);
        }
        this.amount = LootUtils.WhileRoll(chance);
    }
}

