/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.gens.AwakenRuneWordLootGen;
import com.robertx22.mine_and_slash.loot.gens.CompatibleItemLootGen;
import com.robertx22.mine_and_slash.loot.gens.CurrencyLootGen;
import com.robertx22.mine_and_slash.loot.gens.GearLootGen;
import com.robertx22.mine_and_slash.loot.gens.LootBoxGen;
import com.robertx22.mine_and_slash.loot.gens.MapLootGen;
import com.robertx22.mine_and_slash.loot.gens.RuneLootGen;
import com.robertx22.mine_and_slash.loot.gens.RunedGearLootGen;
import com.robertx22.mine_and_slash.loot.gens.UniqueGearLootGen;
import com.robertx22.mine_and_slash.loot.gens.UniqueRuneLootGen;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class MasterLootGen {
    public static List<ItemStack> generateLoot(LootInfo info) {
        List<ItemStack> items = new ArrayList<ItemStack>();
        if (info == null) {
            return items;
        }
        items = MasterLootGen.populateOnce(info);
        int tries = 0;
        while (items.size() < info.minItems) {
            if (++tries > 30) {
                System.out.println("Tried to generate loot many times but failed! " + info.toString());
                break;
            }
            List<ItemStack> extra = MasterLootGen.populateOnce(info);
            int missing = info.minItems - items.size();
            for (int i = 0; i < extra.size() && i < missing; ++i) {
                items.add(extra.get(i));
            }
        }
        while (items.size() > info.maxItems) {
            items.remove(0);
        }
        return items;
    }

    private static List<ItemStack> populateOnce(LootInfo info) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (info == null) {
            return items;
        }
        items.addAll(new CurrencyLootGen(info).tryGenerate());
        items.addAll(new AwakenRuneWordLootGen(info).tryGenerate());
        items.addAll(new GearLootGen(info).tryGenerate());
        items.addAll(new MapLootGen(info).tryGenerate());
        items.addAll(new RuneLootGen(info).tryGenerate());
        items.addAll(new RunedGearLootGen(info).tryGenerate());
        items.addAll(new LootBoxGen(info).tryGenerate());
        items.addAll(new CompatibleItemLootGen(info).tryGenerate());
        items.addAll(new UniqueGearLootGen(info).tryGenerate());
        items.addAll(new UniqueRuneLootGen(info).tryGenerate());
        return items.stream().filter(x -> !x.func_190926_b()).collect(Collectors.toList());
    }

    public static List<ItemStack> generateLoot(EntityCap.UnitData mob, EntityCap.UnitData player, LivingEntity victim, PlayerEntity killer) {
        LootInfo info = new LootInfo(mob, player, victim, killer);
        List<ItemStack> items = MasterLootGen.generateLoot(info);
        return items;
    }

    public static void genAndDrop(EntityCap.UnitData mob, EntityCap.UnitData player, LivingEntity victim, PlayerEntity killer) {
        List<ItemStack> items = MasterLootGen.generateLoot(mob, player, victim, killer);
        for (ItemStack stack : items) {
            victim.func_70099_a(stack, 1.0f);
        }
    }
}

