/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.database.rarities.BaseRaritiesContainer;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.bases.LevelPart;
import com.robertx22.mine_and_slash.loot.blueprints.bases.RarityPart;
import com.robertx22.mine_and_slash.loot.blueprints.bases.TierPart;
import com.robertx22.mine_and_slash.loot.gens.stack_changers.IStackAction;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class ItemBlueprint {
    protected List<IStackAction> actionsAfterGeneration = new ArrayList<IStackAction>();
    boolean itemWasGenerated = false;
    public RarityPart rarity = new RarityPart(this);
    public LevelPart level = new LevelPart(this);
    public TierPart tier = new TierPart(this);

    public ItemBlueprint(int level) {
        this.level.number = level;
        this.onConstruct();
    }

    public ItemBlueprint(LootInfo info) {
        this.level.number = info.level;
        this.tier.number = info.tier;
        this.onConstruct();
    }

    public ItemBlueprint(int level, int tier) {
        this.level.number = level;
        this.tier.number = tier;
        this.onConstruct();
    }

    void onConstruct() {
    }

    abstract ItemStack generate();

    public abstract BaseRaritiesContainer<? extends Rarity> getRarityContainer();

    public final ItemStack createStack() {
        this.checkAndSetGeneratedBoolean();
        ItemStack stack = this.generate();
        this.actionsAfterGeneration.forEach(x -> x.changeStack(stack));
        return stack;
    }

    private void checkAndSetGeneratedBoolean() {
        if (this.itemWasGenerated) {
            try {
                throw new Exception("Do not use a blueprint instance to make more than 1 item!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.itemWasGenerated = true;
        }
    }
}

