/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.database.map_affixes.BaseMapAffix;
import com.robertx22.mine_and_slash.database.map_affixes.beneficial.BonusEleDmgAffix;
import com.robertx22.mine_and_slash.database.rarities.BaseRaritiesContainer;
import com.robertx22.mine_and_slash.database.rarities.MapRarity;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.misc.ItemMap;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.IWPPart;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class MapBlueprint
extends ItemBlueprint {
    public static final int PERMADEATH_CHANCE = 10;
    public IWPPart iwp = new IWPPart(this);

    public MapBlueprint(int level, int worldTier) {
        super(level);
        this.tier.minTier = 1;
        this.tier.number = worldTier;
    }

    @Override
    public BaseRaritiesContainer<? extends Rarity> getRarityContainer() {
        return Rarities.Maps;
    }

    @Override
    public ItemStack generate() {
        MapItemData data = this.createData();
        MapRarity rarity = (MapRarity)this.rarity.get();
        ItemStack stack = new ItemStack((IItemProvider)ItemMap.Items.get(rarity.Rank()));
        Map.Save(stack, data);
        return stack;
    }

    public MapItemData createData() {
        MapItemData data = new MapItemData();
        MapRarity rarity = (MapRarity)this.rarity.get();
        data.rarity = rarity.Rank();
        data.tier = (Integer)this.tier.get();
        data.level = (Integer)this.level.get();
        this.genAffixes(data, rarity);
        data.worldGeneratorName = ((IWP)this.iwp.get()).GUID();
        return data;
    }

    private MapItemData genAffixes(MapItemData map, MapRarity rarity) {
        int amount = RandomUtils.RandomRange(rarity.AffixAmount().min, rarity.AffixAmount().max);
        ArrayList<String> affixes = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            BaseMapAffix affix = RandomUtils.weightedRandom(SlashRegistry.MapAffixes().getAll().values());
            while (affixes.contains(affix.GUID()) || affix.isBeneficial()) {
                affix = RandomUtils.weightedRandom(SlashRegistry.MapAffixes().getAll().values());
            }
            int percent = RandomUtils.RandomRange(rarity.StatPercents().min, rarity.StatPercents().max);
            map.affixes.add(new MapAffixData(affix, percent));
            affixes.add(affix.GUID());
        }
        int percent = RandomUtils.RandomRange(rarity.StatPercents().min, rarity.StatPercents().max);
        List possible = new BonusEleDmgAffix(Elements.Nature).generateAllSingleVariations();
        map.affixes.add(new MapAffixData((BaseMapAffix)RandomUtils.weightedRandom(possible), percent));
        return map;
    }
}

