/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.database.rarities.BaseRaritiesContainer;
import com.robertx22.mine_and_slash.database.runes.base.BaseRune;
import com.robertx22.mine_and_slash.database.runes.base.RuneItem;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.UniqueRunePart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class UniqueRuneBlueprint
extends ItemBlueprint {
    public UniqueRunePart uniqueRunePart = new UniqueRunePart(this);

    public UniqueRuneBlueprint(int level, int tier) {
        super(level);
        this.tier.number = tier;
        this.rarity.setSpecificRarity(-1);
    }

    @Override
    ItemStack generate() {
        BaseRune rune = (BaseRune)this.uniqueRunePart.get();
        RuneItem item = rune.getItemFromRegistry(-1);
        ItemStack stack = ItemStack.field_190927_a;
        if (rune != null && item != null) {
            stack = new ItemStack((IItemProvider)item);
            RuneItemData data = new RuneItemData();
            data.rarity = ((Rarity)this.rarity.get()).Rank();
            data.name = rune.GUID();
            data.level = (Integer)this.level.get();
            data.tier = rune.getTier();
            data.armor = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(rune.armorStat()));
            data.weapon = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(rune.weaponStat()));
            data.jewerly = StatModData.NewRandom(data.getRarity(), RandomUtils.weightedRandom(rune.jewerlyStat()));
            Rune.Save(stack, data);
        }
        return stack;
    }

    @Override
    public BaseRaritiesContainer<? extends Rarity> getRarityContainer() {
        return Rarities.Runes;
    }
}

