/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints.bases;

import com.robertx22.mine_and_slash.database.rarities.BaseRaritiesContainer;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.BlueprintPart;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.List;
import java.util.stream.Collectors;

public class RarityPart
extends BlueprintPart<Rarity> {
    BaseRaritiesContainer container;
    public int minRarity = -1;
    public int maxRarity = 5;
    public float chanceForHigherRarity = 0.0f;

    public void setChanceForHigherRarityBasedOnMapTier() {
        this.chanceForHigherRarity = SlashRegistry.Tiers().get((String)new StringBuilder().append(this.blueprint.tier.get()).append((String)"").toString()).chance_for_higher_drop_rarity;
    }

    public RarityPart(ItemBlueprint blueprint) {
        super(blueprint);
        this.container = blueprint.getRarityContainer();
    }

    @Override
    protected Rarity generateIfNull() {
        List possible = this.container.getAllRarities().stream().filter(x -> {
            int r = ((Rarity)x).Rank();
            return r >= this.minRarity && r <= this.maxRarity;
        }).collect(Collectors.toList());
        Rarity rar = (Rarity)RandomUtils.weightedRandom(possible);
        if (rar.Rank() < 4 && RandomUtils.roll(this.chanceForHigherRarity)) {
            rar = this.container.get(rar.Rank() + 1);
        }
        return rar;
    }

    public void setSpecificRarity(int rank) {
        this.set(this.container.get(rank));
    }
}

