/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.data_generation.compatible_items.CompatibleItem;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.BaseLootGen;
import com.robertx22.mine_and_slash.registry.FilterListWrap;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CompatibleItemLootGen
extends BaseLootGen<GearBlueprint> {
    public CompatibleItemLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        return ((Double)ModConfig.INSTANCE.DropRates.COMPATIBLE_ITEMS_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.CompatibleItem;
    }

    @Override
    public boolean condition() {
        return (Boolean)ModConfig.INSTANCE.Server.USE_COMPATIBILITY_ITEMS.get() != false && this.info.mobData != null;
    }

    @Override
    public ItemStack generateOne() {
        return CompatibleItemLootGen.gen(this.info.mobData.getLevel());
    }

    public static ItemStack gen(int level) {
        try {
            ResourceLocation res;
            CompatibleItem config;
            FilterListWrap<CompatibleItem> possible = SlashRegistry.CompatibleItems().getFilterWrapped(x -> x.add_to_loot_drops);
            if (!possible.list.isEmpty() && (config = possible.random()) != null && ForgeRegistries.ITEMS.containsKey(res = new ResourceLocation(config.item_id))) {
                ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(res));
                return config.create(stack, level);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }
}

