/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.gens.util;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RunedGearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueGearBlueprint;
import com.robertx22.mine_and_slash.registry.FilterListWrap;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.ChaosStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.gearitem.PrefixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.PrimaryStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.SecondaryStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatRequirementsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.SuffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.UniqueStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.rune.RunesData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class GearCreationUtils {
    public static ItemStack CreateStack(GearItemData data) {
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }

    public static ItemStack CreateStack(GearBlueprint blueprint) {
        GearItemData data = GearCreationUtils.CreateData(blueprint);
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }

    public static ItemStack CreateStack(GearBlueprint blueprint, GearItemEnum type) {
        GearItemData data = GearCreationUtils.CreateData(blueprint, type);
        ItemStack stack = new ItemStack((IItemProvider)data.getItem());
        Gear.Save(stack, data);
        return stack;
    }

    public static GearItemData CreateData(GearBlueprint blueprint) {
        GearItemEnum type = GearItemEnum.random();
        if (blueprint instanceof RunedGearBlueprint) {
            type = GearItemEnum.RUNED;
        } else if (blueprint instanceof UniqueGearBlueprint) {
            type = GearItemEnum.UNIQUE;
        }
        return GearCreationUtils.CreateData(blueprint, type);
    }

    public static boolean canMakeUnique(GearBlueprint blueprint) {
        FilterListWrap<IUnique> wrap = SlashRegistry.UniqueGears().getWrapped().ofTierOrLess((Integer)blueprint.tier.get());
        if (blueprint.gearItemSlot.isGenerated()) {
            wrap = wrap.ofSpecificGearType(((GearItemSlot)blueprint.gearItemSlot.get()).GUID());
        }
        return !wrap.list.isEmpty();
    }

    public static GearItemData CreateData(GearBlueprint blueprint, GearItemEnum type) {
        GearRarity rarity = (GearRarity)blueprint.rarity.get();
        GearItemData data = new GearItemData();
        data.level = (Integer)blueprint.level.get();
        data.Rarity = rarity.Rank();
        if (blueprint instanceof UniqueGearBlueprint) {
            if (!GearCreationUtils.canMakeUnique(blueprint)) {
                data.Rarity = ((GearRarity)Rarities.Gears.random()).Rank();
            } else {
                UniqueGearBlueprint uniqprint = (UniqueGearBlueprint)blueprint;
                IUnique unique = (IUnique)uniqprint.unique.get();
                if (unique != null) {
                    blueprint.gearItemSlot.forceSet(unique.getGearSlot());
                    data.gearTypeName = unique.getGearSlot().GUID();
                    data.isUnique = true;
                    data.uniqueGUID = unique.GUID();
                    data.uniqueStats = new UniqueStatsData(unique.GUID());
                    data.uniqueStats.RerollFully(data);
                    if (unique.canGetSet()) {
                        data.set = blueprint.getSet(data).getSetData();
                    }
                } else {
                    data.Rarity = 0;
                }
            }
        } else {
            ((GearItemSlot)blueprint.gearItemSlot.get()).GUID();
        }
        data.gearTypeName = ((GearItemSlot)blueprint.gearItemSlot.get()).GUID();
        data.requirements = new StatRequirementsData();
        data.requirements.create(data);
        if (type.canGetPrimaryStats()) {
            data.primaryStats = new PrimaryStatsData();
            data.primaryStats.RerollFully(data);
        }
        if (type.canGetSecondaryStats()) {
            data.secondaryStats = new SecondaryStatsData();
            data.secondaryStats.RerollFully(data);
        }
        if (type.canGetChaosStats() && blueprint.getsChaosStats()) {
            data.chaosStats = new ChaosStatsData();
            data.chaosStats.RerollFully(data);
        }
        if (type.canGetAffixes()) {
            if (((Boolean)blueprint.suffixChancePart.get()).booleanValue()) {
                data.suffix = new SuffixData();
                data.suffix.RerollFully(data);
            }
            if (((Boolean)blueprint.prefixChancePart.get()).booleanValue()) {
                data.prefix = new PrefixData();
                data.prefix.RerollFully(data);
            }
        }
        if (type.canGetSet()) {
            data.set = blueprint.getSet(data).getSetData();
        }
        if (type == GearItemEnum.RUNED) {
            data.runes = new RunesData();
            data.runes.capacity = rarity.runeSlots();
        }
        if (((Boolean)blueprint.unidentifiedPart.get()).booleanValue()) {
            data.setIdentified(false);
        }
        return data;
    }
}

