/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg;

import com.robertx22.mine_and_slash.a_libraries.curios.GenerateCurioDataJsons;
import com.robertx22.mine_and_slash.a_libraries.curios.RegisterCurioSlots;
import com.robertx22.mine_and_slash.blocks.scrabble.ScrabbleTile;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.data_generation.affixes.AffixDataPackManager;
import com.robertx22.mine_and_slash.data_generation.compatible_items.CompatibleItemDataPackManager;
import com.robertx22.mine_and_slash.data_generation.mob_affixes.MobAffixDataPackManager;
import com.robertx22.mine_and_slash.data_generation.rarities.GearRarityManager;
import com.robertx22.mine_and_slash.data_generation.runes.RuneDataPackManager;
import com.robertx22.mine_and_slash.data_generation.runewords.RunewordDataPackManager;
import com.robertx22.mine_and_slash.data_generation.sets.SetDataPackManager;
import com.robertx22.mine_and_slash.data_generation.tiers.TierDatapackManager;
import com.robertx22.mine_and_slash.data_generation.unique_gears.UniqueGearDatapackManager;
import com.robertx22.mine_and_slash.db_lists.initializers.CurrencyItems;
import com.robertx22.mine_and_slash.error_checks.DunSameSeedAreSame;
import com.robertx22.mine_and_slash.error_checks.base.ErrorChecks;
import com.robertx22.mine_and_slash.mmorpg.RegDeffered;
import com.robertx22.mine_and_slash.mmorpg.RegisterEvents;
import com.robertx22.mine_and_slash.mmorpg.proxy.ClientProxy;
import com.robertx22.mine_and_slash.mmorpg.proxy.IProxy;
import com.robertx22.mine_and_slash.mmorpg.proxy.ServerProxy;
import com.robertx22.mine_and_slash.mmorpg.registers.client.ClientSetup;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CapabilityRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ConfigRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CriteriaRegisters;
import com.robertx22.mine_and_slash.mmorpg.registers.common.PacketRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.server.CommandRegister;
import com.robertx22.mine_and_slash.new_content.auto_comp.DeterminePowerLevels;
import com.robertx22.mine_and_slash.onevent.data_gen.OnGatherData;
import com.robertx22.mine_and_slash.onevent.world.OnShutdownResetMaps;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.tests.CountUniqueGearTypes;
import com.robertx22.mine_and_slash.uncommon.develeper.CreateLangFile;
import com.robertx22.mine_and_slash.uncommon.testing.TestManager;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod(value="mmorpg")
@Mod.EventBusSubscriber
public class MMORPG {
    public static boolean RUN_DEV_TOOLS = false;
    public static Logger LOGGER = Logger.getLogger("Mine and Slash");
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel Network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("mmorpg", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static boolean statEffectDebuggingEnabled() {
        return false;
    }

    public static void devToolsLog(String string) {
        if (RUN_DEV_TOOLS) {
            System.out.println(string);
        }
    }

    public static void devToolsErrorLog(String string) {
        if (RUN_DEV_TOOLS) {
            try {
                throw new Exception(string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MMORPG() {
        System.out.println("Starting Mine and Slash");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SlashRegistry.initRegistries();
        RegisterEvents.register();
        ConfigRegister.registerForgeConfigs();
        SlashRegistry.registerAllItems();
        SlashRegistry.checkGuidValidity();
        bus.addListener(this::commonSetupEvent);
        bus.addListener(this::interModProcessEvent);
        bus.addListener(this::interModEnqueue);
        bus.addListener(this::onloadComplete);
        bus.addListener(new OnGatherData()::onGatherData);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        RegDeffered.register(bus);
        new DunSameSeedAreSame().check();
        ScrabbleTile.loadWordList();
    }

    public static void logError(String s) {
        try {
            throw new Exception(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        System.out.println("mmorpg:FMLCommonSetupEvent");
        PacketRegister.register();
        CapabilityRegister.register();
        CriteriaRegisters.register();
    }

    private void interModEnqueue(InterModEnqueueEvent event) {
        System.out.println("mmorpg:InterModEnqueueEvent");
        RegisterCurioSlots.register(event);
    }

    private void interModProcessEvent(InterModProcessEvent event) {
        System.out.println("mmorpg:InterModProcessEvent");
        ConfigRegister.registerCustomConfigs();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ClientSetup.setup(event);
    }

    @SubscribeEvent
    public static void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        new CurrencyItems().registerAll();
        IReloadableResourceManager manager = event.getServer().func_195570_aG();
        manager.func_219534_a((IFutureReloadListener)new TierDatapackManager());
        manager.func_219534_a((IFutureReloadListener)new SetDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new AffixDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new RuneDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new MobAffixDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new RunewordDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new UniqueGearDatapackManager());
        manager.func_219534_a((IFutureReloadListener)new CompatibleItemDataPackManager());
        manager.func_219534_a((IFutureReloadListener)new GearRarityManager());
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        DeterminePowerLevels.setupHashMaps();
        CommandRegister.Register(event.getServer());
        SlashRegistry.checkGuidValidity();
        ErrorChecks.getAll().forEach(x -> x.check());
        SlashRegistry.unregisterInvalidEntries();
        if (RUN_DEV_TOOLS) {
            TestManager.RunAllTests();
            CreateLangFile.create();
            GenerateCurioDataJsons.generate();
            CountUniqueGearTypes.count();
        }
        if (((Boolean)ModConfig.INSTANCE.Server.DISABLE_VANILLA_HP_REGEN.get()).booleanValue()) {
            GameRules.BooleanValue value = (GameRules.BooleanValue)ServerLifecycleHooks.getCurrentServer().func_200252_aR().func_223585_a(GameRules.field_223606_i);
            value.func_223570_a(false, ServerLifecycleHooks.getCurrentServer());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppedEvent event) {
        OnShutdownResetMaps.deleteFolders();
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
    }

    public static <MSG> void sendToTracking(MSG msg, Entity entity) {
        if (msg == null || entity == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
        if (entity instanceof PlayerEntity) {
            MMORPG.sendToClient(msg, (ServerPlayerEntity)entity);
        }
    }

    public static <MSG> void sendToTracking(MSG msg, BlockPos pos, World world) {
        if (msg == null || world == null) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0, world.func_201675_m().func_186058_p());
        Network.send(PacketDistributor.NEAR.with(() -> point), msg);
    }

    public static <MSG> void sendToClient(MSG msg, ServerPlayerEntity player) {
        if (player != null && msg != null) {
            Network.sendTo(msg, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static <MSG> void syncMapData(ServerPlayerEntity p) {
        if (p != null) {
            MMORPG.sendToClient(new SyncCapabilityToClient(p, PlayerCaps.MAP_DATA), p);
        }
    }

    public static <MSG> void sendToServer(MSG msg) {
        Network.sendToServer(msg);
    }

    public void onloadComplete(FMLLoadCompleteEvent evt) {
    }
}

