/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.config.base.ISerializedConfig;
import com.robertx22.mine_and_slash.config.base_player_stat.BasePlayerStatSerial;
import com.robertx22.mine_and_slash.config.compatible_items.OldCompatibleItemSerial;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionsSerial;
import com.robertx22.mine_and_slash.config.forge.ClientContainer;
import com.robertx22.mine_and_slash.config.forge.CommonConfig;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.lvl_penalty.LvlPenaltySerial;
import com.robertx22.mine_and_slash.config.mod_dmg_whitelist.ModDmgWhitelistSerial;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfigsSerial;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryContainer;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigRegister {
    public static HashMap<Config, ISerializedConfig> CONFIGS = new HashMap();
    public static HashMap<Config, List<String>> SAVED_JSONS = new HashMap();

    public static void registerCustomConfigs() {
        CONFIGS.put(Config.MOD_DMG_WHITELIST, ModDmgWhitelistSerial.INSTANCE);
        CONFIGS.put(Config.MOD_ENTITY, ModEntityConfigsSerial.INSTANCE);
        CONFIGS.put(Config.DIMENSIONS, DimensionsSerial.INSTANCE);
        CONFIGS.put(Config.BASE_PLAYER_STATS, BasePlayerStatSerial.INSTANCE);
        CONFIGS.put(Config.LVL_PENALTY, LvlPenaltySerial.INSTANCE);
        ConfigRegister.unregisterFlaggedEntries();
        ConfigRegister.generateIfEmpty();
        CONFIGS.values().forEach(x -> x.autoFixProblems());
        ConfigRegister.load();
        ConfigRegister.createTutorials();
    }

    private static void createTutorials() {
        OldCompatibleItemSerial.INSTANCE.generateConfigTutorials();
    }

    private static void load() {
        CONFIGS.values().forEach(x -> x.loadOnServer());
    }

    private static void generateIfEmpty() {
        CONFIGS.values().forEach(x -> x.generateIfEmpty());
    }

    public static void unregisterFlaggedEntries() {
        for (SlashRegistryContainer container : SlashRegistry.getAllRegistries()) {
            List list = container.getList();
            for (ISlashRegistryEntry entry : list) {
                if (!entry.unregisterBeforeConfigsLoad()) continue;
                container.unRegister(entry);
            }
        }
    }

    public static void registerForgeConfigs() {
        ModLoadingContext ctx = ModLoadingContext.get();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ctx.registerConfig(ModConfig.Type.CLIENT, ClientContainer.spec, "MineAndSlash-Client.toml"));
        ctx.registerConfig(ModConfig.Type.SERVER, ModConfig.spec, "MineAndSlash-Server.toml");
        ctx.registerConfig(ModConfig.Type.COMMON, CommonConfig.spec, "MineAndSlash-Common.toml");
    }

    public static enum Config {
        MOD_DMG_WHITELIST,
        MOD_ENTITY,
        DIMENSIONS,
        LVL_PENALTY,
        BASE_PLAYER_STATS;

    }
}

