/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.database.spells.entities.cloud.ArrowStormEntity;
import com.robertx22.mine_and_slash.database.spells.entities.cloud.BlizzardEntity;
import com.robertx22.mine_and_slash.database.spells.entities.cloud.ThunderstormEntity;
import com.robertx22.mine_and_slash.database.spells.entities.cloud.VolcanoEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.BlastTrapEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.DivineTribulationEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.FireBombEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.GroundSlamEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.LightningTotemEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.RangerArrowEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.SeedEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.SnareTrapEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.ThrowFlameEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.TidalWaveEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.WeakenTrapEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.WhirlpoolEntity;
import com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt.FireballEntity;
import com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt.FrostballEntity;
import com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt.FrozenOrbEntity;
import com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt.LightningBallEntity;
import com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt.PoisonBallEntity;
import com.robertx22.mine_and_slash.database.spells.entities.summons.SpiderPetEntity;
import com.robertx22.mine_and_slash.database.spells.entities.summons.SpiritWolfPetEntity;
import com.robertx22.mine_and_slash.database.spells.entities.trident.SpearOfJudgementEntity;
import com.robertx22.mine_and_slash.database.spells.entities.trident.ThunderspearEntity;
import com.robertx22.mine_and_slash.new_content.trader.TraderEntity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegister {
    public static List<EntityType<? extends Entity>> ENTITY_TYPES = new LinkedList<EntityType<? extends Entity>>();
    public static List<EntityType<? extends Entity>> BOSSES = new LinkedList<EntityType<? extends Entity>>();
    public static List<EntityType<? extends Entity>> ENTITY_THAT_USE_ITEM_RENDERS = new LinkedList<EntityType<? extends Entity>>();
    public static final EntityType<? extends Entity> THUNDERSTORM;
    public static final EntityType<? extends TridentEntity> THUNDER_SPEAR;
    public static final EntityType<? extends TridentEntity> HOLY_SPEAR;
    public static final EntityType<? extends Entity> LIGHTNING_TOTEM;
    public static final EntityType<? extends Entity> LIGHTNING_BALL;
    public static final EntityType<? extends Entity> FIREBOLT;
    public static final EntityType<? extends Entity> FIRE_BOMB;
    public static final EntityType<? extends Entity> THROW_FLAMES;
    public static final EntityType<? extends Entity> VOLCANO;
    public static final EntityType<? extends Entity> POISON_BALL;
    public static final EntityType<? extends Entity> FROSTBOLT;
    public static final EntityType<? extends Entity> WHIRPOOL;
    public static final EntityType<? extends Entity> BLIZZARD;
    public static final EntityType<? extends Entity> TIDAL_WAVE;
    public static final EntityType<? extends Entity> GROUND_SLAM;
    public static final EntityType<? extends Entity> FROZEN_ORB;
    public static final EntityType<RangerArrowEntity> RANGER_ARROW;
    public static final EntityType<? extends Entity> ARROW_STORM;
    public static final EntityType<? extends Entity> SNARE_TRAP;
    public static final EntityType<? extends Entity> WEAKEN_TRAP;
    public static final EntityType<? extends Entity> BLAST_TRAP;
    public static final EntityType<? extends Entity> DIVINE_TRIBULATION;
    public static final EntityType<? extends Entity> SEED;
    public static final EntityType<TraderEntity> TRADER;
    public static final EntityType<SpiderPetEntity> SPIDER_PET;
    public static final EntityType<SpiritWolfPetEntity> SPIRIT_WOLF_PET;

    public static EntityType randomBoss() {
        return RandomUtils.randomFromList(BOSSES);
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        ENTITY_TYPES.forEach(entityType -> event.getRegistry().register((IForgeRegistryEntry)entityType));
    }

    public static EntityType addBoss(EntityType type, String id) {
        type.setRegistryName(new ResourceLocation("mmorpg", id));
        ENTITY_TYPES.add((EntityType<? extends Entity>)type);
        BOSSES.add((EntityType<? extends Entity>)type);
        return type;
    }

    private static <T extends Entity> EntityType<T> projectile(EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> bif, String id) {
        return EntityRegister.projectile(factory, bif, id, true);
    }

    private static <T extends Entity> EntityType<T> projectile(EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> bif, String id, boolean itemRender) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(bif).func_220321_a(0.5f, 0.5f).func_206830_a("mmorpg:" + id.toLowerCase(Locale.ROOT));
        type.setRegistryName(new ResourceLocation("mmorpg", id.toLowerCase(Locale.ROOT)));
        ENTITY_TYPES.add((EntityType<? extends Entity>)type);
        if (itemRender) {
            ENTITY_THAT_USE_ITEM_RENDERS.add((EntityType<? extends Entity>)type);
        }
        return type;
    }

    static {
        HOLY_SPEAR = EntityRegister.projectile(SpearOfJudgementEntity::new, SpearOfJudgementEntity::new, "holy_spear", false);
        BLIZZARD = EntityRegister.projectile(BlizzardEntity::new, BlizzardEntity::new, "blizzard");
        FROSTBOLT = EntityRegister.projectile(FrostballEntity::new, FrostballEntity::new, "frostball");
        FROZEN_ORB = EntityRegister.projectile(FrozenOrbEntity::new, FrozenOrbEntity::new, "frozen_orb");
        WHIRPOOL = EntityRegister.projectile(WhirlpoolEntity::new, WhirlpoolEntity::new, "whirlpool");
        TIDAL_WAVE = EntityRegister.projectile(TidalWaveEntity::new, TidalWaveEntity::new, "tidal_wave");
        GROUND_SLAM = EntityRegister.projectile(GroundSlamEntity::new, GroundSlamEntity::new, "ground_slam");
        POISON_BALL = EntityRegister.projectile(PoisonBallEntity::new, PoisonBallEntity::new, "poison_ball");
        THUNDERSTORM = EntityRegister.projectile(ThunderstormEntity::new, ThunderstormEntity::new, "thunderstorm");
        THUNDER_SPEAR = EntityRegister.projectile(ThunderspearEntity::new, ThunderspearEntity::new, "thunder_spear", false);
        LIGHTNING_TOTEM = EntityRegister.projectile(LightningTotemEntity::new, LightningTotemEntity::new, "lightning_totem");
        LIGHTNING_BALL = EntityRegister.projectile(LightningBallEntity::new, LightningBallEntity::new, "lightning_ball");
        FIREBOLT = EntityRegister.projectile(FireballEntity::new, FireballEntity::new, "fireball");
        FIRE_BOMB = EntityRegister.projectile(FireBombEntity::new, FireBombEntity::new, "fire_bomb");
        THROW_FLAMES = EntityRegister.projectile(ThrowFlameEntity::new, ThrowFlameEntity::new, "seeker_flame");
        VOLCANO = EntityRegister.projectile(VolcanoEntity::new, VolcanoEntity::new, "volcano");
        RANGER_ARROW = EntityRegister.projectile(RangerArrowEntity::new, RangerArrowEntity::new, "ranger_arrow");
        ARROW_STORM = EntityRegister.projectile(ArrowStormEntity::new, ArrowStormEntity::new, "arrow_storm");
        SNARE_TRAP = EntityRegister.projectile(SnareTrapEntity::new, SnareTrapEntity::new, "snare_trap");
        WEAKEN_TRAP = EntityRegister.projectile(WeakenTrapEntity::new, WeakenTrapEntity::new, "weaken_trap");
        BLAST_TRAP = EntityRegister.projectile(BlastTrapEntity::new, BlastTrapEntity::new, "blast_trap");
        DIVINE_TRIBULATION = EntityRegister.projectile(DivineTribulationEntity::new, DivineTribulationEntity::new, "divine_tribulation");
        SEED = EntityRegister.projectile(SeedEntity::new, SeedEntity::new, "seed_entity");
        TRADER = EntityType.Builder.func_220322_a(TraderEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(TraderEntity::new).func_220321_a(0.5f, 2.0f).func_206830_a("mmorpg:trader");
        TRADER.setRegistryName(new ResourceLocation("mmorpg", "trader"));
        ENTITY_TYPES.add(TRADER);
        SPIDER_PET = EntityType.Builder.func_220322_a(SpiderPetEntity::new, (EntityClassification)EntityClassification.MONSTER).setCustomClientFactory(SpiderPetEntity::new).func_220321_a(1.4f, 0.9f).func_206830_a("mmorpg:spider_pet");
        SPIDER_PET.setRegistryName(new ResourceLocation("mmorpg", "spider_pet"));
        ENTITY_TYPES.add(SPIDER_PET);
        SPIRIT_WOLF_PET = EntityType.Builder.func_220322_a(SpiritWolfPetEntity::new, (EntityClassification)EntityClassification.MONSTER).setCustomClientFactory(SpiritWolfPetEntity::new).func_220321_a(0.6f, 0.85f).func_206830_a("mmorpg:spirit_wolf_pet");
        SPIRIT_WOLF_PET.setRegistryName(new ResourceLocation("mmorpg", "spirit_wolf_pet"));
        ENTITY_TYPES.add(SPIRIT_WOLF_PET);
    }
}

