/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.gearitems.armor.cloth.ClothBootsItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.cloth.ClothChestItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.cloth.ClothHelmetItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.cloth.ClothPantsItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.leather.LeatherBootsItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.leather.LeatherChestItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.leather.LeatherHelmetItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.leather.LeatherPantsItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.plate.PlateBootsItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.plate.PlateChestItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.plate.PlateHelmetItem;
import com.robertx22.mine_and_slash.items.gearitems.armor.plate.PlatePantsItem;
import com.robertx22.mine_and_slash.items.gearitems.baubles.ItemBracelet;
import com.robertx22.mine_and_slash.items.gearitems.baubles.ItemCharm;
import com.robertx22.mine_and_slash.items.gearitems.baubles.ItemNecklace;
import com.robertx22.mine_and_slash.items.gearitems.baubles.ItemRing;
import com.robertx22.mine_and_slash.items.gearitems.offhands.MyTorch;
import com.robertx22.mine_and_slash.items.gearitems.offhands.NormalShield;
import com.robertx22.mine_and_slash.items.gearitems.offhands.ShieldRenderer;
import com.robertx22.mine_and_slash.items.gearitems.weapons.ItemAxe;
import com.robertx22.mine_and_slash.items.gearitems.weapons.ItemBow;
import com.robertx22.mine_and_slash.items.gearitems.weapons.ItemHammer;
import com.robertx22.mine_and_slash.items.gearitems.weapons.ItemStaff;
import com.robertx22.mine_and_slash.items.gearitems.weapons.ItemSword;
import com.robertx22.mine_and_slash.items.misc.ItemMap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GearItemRegisters {
    public static List<Item> items = new ArrayList<Item>();

    private static void register() {
        for (GearRarity rarity : Rarities.Gears.getNormalRarities()) {
            Item.Properties shieldprop = ItemUtils.getDefaultGearProperties().func_200915_b(750);
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> shieldprop.setISTER(ShieldRenderer::new));
            int rank = rarity.Rank();
            GearItemRegisters.regRarities((Item)new NormalShield(rarity.Rank(), shieldprop), NormalShield.Items, "shields/normal_shield", rarity.Rank());
            GearItemRegisters.regRarities(new MyTorch(rarity.Rank()), MyTorch.Items, "torch/torch", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ItemSword(rarity.Rank()), ItemSword.Items, "sword/sword", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ItemHammer(rarity.Rank()), ItemHammer.Items, "hammer/hammer", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ItemAxe(rarity.Rank()), ItemAxe.Items, "axe/axe", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ItemBow(rarity.Rank()), ItemBow.Items, "bow/bow", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ItemStaff(rarity.Rank()), ItemStaff.Items, "staff/staff", rarity.Rank());
            GearItemRegisters.regRarities(new ItemNecklace(rarity.Rank()), ItemNecklace.Items, "necklace/necklace", rarity.Rank());
            GearItemRegisters.regRarities(new ItemBracelet(rarity.Rank()), ItemBracelet.Items, "bracelet/bracelet", rarity.Rank());
            GearItemRegisters.regRarities(new ItemRing(rarity.Rank()), ItemRing.Items, "ring/ring", rarity.Rank());
            GearItemRegisters.regRarities(new ItemCharm(rarity.Rank()), ItemCharm.Items, "charm/charm", rarity.Rank());
            GearItemRegisters.regRarities((Item)new PlateBootsItem(rank), PlateBootsItem.Items, "boots/plate/boots", rarity.Rank());
            GearItemRegisters.regRarities((Item)new PlateChestItem(rank), PlateChestItem.Items, "chest/plate/chest", rarity.Rank());
            GearItemRegisters.regRarities((Item)new PlateHelmetItem(rank), PlateHelmetItem.Items, "helmet/plate/helmet", rarity.Rank());
            GearItemRegisters.regRarities((Item)new PlatePantsItem(rank), PlatePantsItem.Items, "pants/plate/pants", rarity.Rank());
            GearItemRegisters.regRarities((Item)new LeatherBootsItem(rank), LeatherBootsItem.Items, "boots/leather/boots", rarity.Rank());
            GearItemRegisters.regRarities((Item)new LeatherChestItem(rank), LeatherChestItem.Items, "chest/leather/chest", rarity.Rank());
            GearItemRegisters.regRarities((Item)new LeatherHelmetItem(rank), LeatherHelmetItem.Items, "helmet/leather/helmet", rarity.Rank());
            GearItemRegisters.regRarities((Item)new LeatherPantsItem(rank), LeatherPantsItem.Items, "pants/leather/pants", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ClothBootsItem(rank), ClothBootsItem.Items, "boots/cloth/boots", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ClothChestItem(rank), ClothChestItem.Items, "chest/cloth/chest", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ClothHelmetItem(rank), ClothHelmetItem.Items, "helmet/cloth/helmet", rarity.Rank());
            GearItemRegisters.regRarities((Item)new ClothPantsItem(rank), ClothPantsItem.Items, "pants/cloth/pants", rarity.Rank());
            GearItemRegisters.regRarities(new ItemMap(rank), ItemMap.Items, "map/map", rarity.Rank());
        }
    }

    private static void regRarities(Item item, HashMap<Integer, Item> map, String name, int rarity) {
        String reg = name.toLowerCase(Locale.ROOT) + rarity;
        item.setRegistryName("mmorpg", reg);
        map.put(rarity, item);
        items.add(item);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        System.out.println("Registering Gear Items!");
        GearItemRegisters.register();
        for (Item item : items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }
}

