/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.database.loot_crates.loot_crate_item.MapLootCrateItem;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.bags.AutoSalvageBag;
import com.robertx22.mine_and_slash.items.bags.currency_bag.ItemCurrencyBag;
import com.robertx22.mine_and_slash.items.bags.loot_bag.ItemLootBag;
import com.robertx22.mine_and_slash.items.bags.map_bag.ItemMapBag;
import com.robertx22.mine_and_slash.items.bags.master_bag.ItemMasterBag;
import com.robertx22.mine_and_slash.items.misc.ItemAwakenRuneWord;
import com.robertx22.mine_and_slash.items.misc.ItemCapacitor;
import com.robertx22.mine_and_slash.items.misc.ItemIncreaseRarityNearestEntity;
import com.robertx22.mine_and_slash.items.misc.ItemLevelNearestEntity;
import com.robertx22.mine_and_slash.items.misc.ItemLootbox;
import com.robertx22.mine_and_slash.items.misc.ItemNewbieGearBag;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.interfaces.IGenerated;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemRegister {
    private static List<Item> list = new ArrayList<Item>();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ItemRegister.putInLists();
        ItemRegister.registerSingles(event);
        ItemRegister.registerLists(event);
    }

    private static void putInLists() {
        for (GearRarity x2 : Rarities.Gears.getNormalRarities()) {
            AutoSalvageBag.Items.put(x2.Rank(), new AutoSalvageBag(x2.Rank()));
            ItemCapacitor.ITEMS.put(x2.Rank(), new ItemCapacitor(x2.Rank()));
        }
        for (GearRarity rarity : Rarities.Gears.getNormalRarities().stream().filter(x -> x.Rank() > 2).collect(Collectors.toList())) {
            for (ItemLootbox.LootTypes type : ItemLootbox.LootTypes.values()) {
                for (ItemLootbox.LootBoxSizes size : ItemLootbox.LootBoxSizes.values()) {
                    String reg = ItemLootbox.GetStringForType(rarity.Rank(), type, size);
                    ItemLootbox.Items.put(reg, (ItemLootbox)new ItemLootbox(size, type, rarity.Rank()).setRegistryName(reg));
                }
            }
        }
    }

    private static void registerLists(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        AutoSalvageBag.Items.values().forEach(x -> r.register((IForgeRegistryEntry)x));
        ItemCapacitor.ITEMS.values().forEach(x -> r.register((IForgeRegistryEntry)x));
        ItemLootbox.Items.values().forEach(x -> r.register((IForgeRegistryEntry)x));
        for (IUnique uniq : SlashRegistry.UniqueGears().getSerializable()) {
            r.register((IForgeRegistryEntry)uniq.getItemForRegistration());
        }
        SlashRegistry.Runes().getSerializable().stream().forEach(x -> x.itemMap.getForRegistration().values().forEach(i -> {
            if (i.getRegistryName().func_110624_b().equals("mmorpg")) {
                r.register((IForgeRegistryEntry)i);
            }
        }));
    }

    public static void shcheduleToRegister(Item item) {
        list.add(item);
    }

    private static void registerSingles(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        list.add(new MapLootCrateItem());
        list.add((Item)new ItemCurrencyBag().setRegistryName("mmorpg:currency_bag"));
        list.add((Item)new ItemLootBag().setRegistryName("mmorpg:loot_bag"));
        list.add((Item)new ItemMapBag().setRegistryName("mmorpg:map_bag"));
        list.add((Item)new ItemMasterBag().setRegistryName("mmorpg:master_bag"));
        list.add(new ItemAwakenRuneWord());
        list.add(new ItemIncreaseRarityNearestEntity());
        list.add(new ItemLevelNearestEntity());
        list.add(new ItemNewbieGearBag());
        list.add(SimpleMatItem.CRYSTALLIZED_ESSENCE);
        list.add(SimpleMatItem.INFUSED_IRON);
        list.add(SimpleMatItem.MYTHIC_ESSENCE);
        list.add(SimpleMatItem.GOLDEN_ORB);
        for (Item item : list) {
            if (item instanceof IGenerated) {
                IGenerated gen = (IGenerated)item;
                gen.generateAllPossibleStatVariations().forEach(x -> r.register((IForgeRegistryEntry)((Item)x)));
                continue;
            }
            r.register((IForgeRegistryEntry)item);
        }
    }
}

