/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.mine_and_slash.particles.EleParticleData;
import com.robertx22.mine_and_slash.particles.ParticleDeserializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="mmorpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParticleRegister {
    private static final String eleId = "mmorpg:drip";
    private static final String thunderId = "mmorpg:thunder";
    private static final String bubbleID = "mmorpg:bubble";
    @ObjectHolder(value="mmorpg:drip")
    public static final ParticleType<EleParticleData> DRIP = null;
    @ObjectHolder(value="mmorpg:thunder")
    public static final BasicParticleType THUNDER = null;
    @ObjectHolder(value="mmorpg:bubble")
    public static final BasicParticleType BUBBLE = null;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<ParticleType<?>> event) {
        ParticleRegister.register(eleId, ParticleDeserializer.INSTANCE);
        ParticleRegister.register(thunderId, new BasicParticleType(false));
        ParticleRegister.register(bubbleID, new BasicParticleType(false));
    }

    private static <T extends ParticleType<?>> T register(String name, T particleType) {
        particleType.setRegistryName(name);
        ForgeRegistries.PARTICLE_TYPES.register(particleType);
        return particleType;
    }

    private static <T extends IParticleData> ParticleType register(String name, IParticleData.IDeserializer<T> deseri) {
        ParticleType particleType = new ParticleType(false, deseri);
        return ParticleRegister.register(name, particleType);
    }
}

