/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mobs.entity;

import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ZombieGriefAttackGoal
extends ZombieAttackGoal {
    int breakTicks = 0;
    BlockPos blockPos;

    public ZombieGriefAttackGoal(ZombieEntity zombie, double p_i46803_2_, boolean p_i46803_4_) {
        super(zombie, p_i46803_2_, p_i46803_4_);
    }

    public void func_75246_d() {
        super.func_75246_d();
        try {
            if (EntityUtils.isTryingButCantGetToPlayer((MobEntity)this.field_75441_b)) {
                ++this.breakTicks;
                World world = this.field_75441_b.field_70170_p;
                if (this.blockPos == null) {
                    this.blockPos = this.getBlockPosToGrief();
                }
                if (this.blockPos != null) {
                    Random random = this.field_75441_b.func_70681_au();
                    if (this.breakTicks % 5 == 0) {
                        if (!world.field_72995_K) {
                            double d0 = 0.08;
                            ((ServerWorld)world).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_221574_b)), (double)this.blockPos.func_177958_n() + 0.5, (double)this.blockPos.func_177956_o() + 0.7, (double)this.blockPos.func_177952_p() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.15f);
                        }
                        this.playBreakingSound((IWorld)world, this.blockPos);
                    }
                    if (this.breakTicks > 40) {
                        if (!world.field_72995_K) {
                            for (int i = 0; i < 20; ++i) {
                                double d3 = random.nextGaussian() * 0.02;
                                double d1 = random.nextGaussian() * 0.02;
                                double d2 = random.nextGaussian() * 0.02;
                                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)this.blockPos.func_177958_n() + 0.5, (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p() + 0.5, 1, d3, d1, d2, (double)0.15f);
                            }
                        }
                        this.playBrokenSound(world, this.blockPos);
                        world.func_180501_a(this.blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        this.blockPos = null;
                        this.breakTicks = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playBreakingSound(IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203276_jU, SoundCategory.HOSTILE, 0.5f, 1.1f);
    }

    public void playBrokenSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
    }

    public BlockPos getBlockPosToGrief() {
        BlockPos currentPos;
        BlockPos targetPos = this.field_75441_b.func_70638_az().func_180425_c();
        BlockPos startPos = currentPos = this.field_75441_b.func_180425_c();
        BlockPos[] list = new BlockPos[]{};
        if (targetPos.func_177956_o() > currentPos.func_177956_o()) {
            startPos = startPos.func_177984_a();
            list = new BlockPos[]{startPos, startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177976_e(), startPos.func_177974_f(), startPos.func_177978_c(), startPos.func_177968_d()};
        } else {
            list = targetPos.func_177956_o() == currentPos.func_177956_o() ? new BlockPos[]{startPos.func_177976_e(), startPos.func_177974_f(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177984_a().func_177976_e(), startPos.func_177984_a().func_177974_f(), startPos.func_177984_a().func_177978_c(), startPos.func_177984_a().func_177968_d()} : new BlockPos[]{startPos.func_177977_b()};
        }
        ArrayList<BlockPos> toDestroy = new ArrayList<BlockPos>();
        for (BlockPos blockpos : list) {
            if (!this.field_75441_b.field_70170_p.func_180495_p(blockpos).func_177230_c().func_176223_P().func_200132_m()) continue;
            toDestroy.add(blockpos);
        }
        toDestroy.removeIf(x -> x.func_177956_o() == 0);
        Optional<BlockPos> opt = toDestroy.stream().min(Comparator.comparingInt(x -> (int)x.func_177951_i((Vec3i)targetPos)));
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }
}

