/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content;

import com.mojang.datafixers.Dynamic;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.new_content.BuiltRoom;
import com.robertx22.mine_and_slash.new_content.building.DungeonBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DungeonFeature
extends Feature<NoFeatureConfig> {
    public static int Y_POS = 50;

    public DungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        try {
            if (world.func_201675_m() instanceof IWP) {
                ChunkPos cpos = new ChunkPos(pos);
                DungeonBuilder builder = new DungeonBuilder(world.func_72905_C(), cpos);
                builder.build();
                if (!builder.dungeon.hasRoomForChunk(cpos)) {
                    return false;
                }
                BuiltRoom room = builder.dungeon.getRoomForChunk(cpos);
                if (room == null) {
                    return false;
                }
                MinecraftServer server = world.func_201672_e().func_73046_m();
                TemplateManager templatemanager = server.func_71218_a(world.func_201675_m().func_186058_p()).func_184163_y();
                Template template = templatemanager.func_200219_b(room.getStructure());
                PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(room.data.rotation).func_186222_a(false).func_186218_a(cpos);
                settings.func_186223_a(settings.func_186213_g());
                BlockPos position = new BlockPos(cpos.func_180334_c(), Y_POS, cpos.func_180333_d());
                if (template == null) {
                    System.out.println("FATAL ERROR: Structure does not exist (" + room.getStructure() + ")");
                    return false;
                }
                if (room.data.rotation == Rotation.COUNTERCLOCKWISE_90) {
                    settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                    position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
                } else if (room.data.rotation == Rotation.CLOCKWISE_90) {
                    settings.func_186220_a(Rotation.CLOCKWISE_90);
                    position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
                } else if (room.data.rotation == Rotation.CLOCKWISE_180) {
                    settings.func_186220_a(Rotation.CLOCKWISE_180);
                    position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
                } else {
                    settings.func_186220_a(Rotation.NONE);
                }
                boolean success = template.func_189962_a(world, position, settings, 2);
                return success;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

