/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content;

import com.robertx22.mine_and_slash.new_content.BuiltRoom;
import com.robertx22.mine_and_slash.new_content.building.DungeonBuilder;
import com.robertx22.mine_and_slash.new_content.data_processors.bases.ChunkProcessData;
import com.robertx22.mine_and_slash.new_content.registry.DataProcessor;
import com.robertx22.mine_and_slash.new_content.registry.DataProcessors;
import com.robertx22.mine_and_slash.saveclasses.dungeon_dimension.DungeonData;
import com.robertx22.mine_and_slash.uncommon.capability.chunk.DungeonChunkCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ProcessChunkBlocks {
    private static void logRoomForPos(World world, BlockPos pos) {
        try {
            ChunkPos cpos = new ChunkPos(pos);
            DungeonBuilder builder = new DungeonBuilder(world.func_72905_C(), cpos);
            builder.build();
            BuiltRoom room = builder.dungeon.getRoomForChunk(cpos);
            System.out.println("Room affected: " + room.getStructure().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void process(LivingEntity player) {
        try {
            if (WorldUtils.isMapWorldClass((IWorld)player.field_70170_p)) {
                ChunkPos start = new ChunkPos(player.func_180425_c());
                ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
                chunks.add(start);
                chunks.add(new ChunkPos(start.field_77276_a + 1, start.field_77275_b));
                chunks.add(new ChunkPos(start.field_77276_a - 1, start.field_77275_b));
                chunks.add(new ChunkPos(start.field_77276_a, start.field_77275_b + 1));
                chunks.add(new ChunkPos(start.field_77276_a, start.field_77275_b - 1));
                WorldMapCap.IWorldMapData mapdata = Load.world(player.field_70170_p);
                mapdata.init(Load.playerMapData((PlayerEntity)player).getMap(), start);
                if (!mapdata.getData().hasData(start)) {
                    return;
                }
                for (ChunkPos cpos : chunks) {
                    if (!player.field_70170_p.func_217354_b(cpos.field_77276_a, cpos.field_77275_b)) continue;
                    Chunk chunk = player.field_70170_p.func_212866_a_(cpos.field_77276_a, cpos.field_77275_b);
                    chunk.getCapability(DungeonChunkCap.Data).ifPresent(c -> {
                        if (!c.isDoneProcessing()) {
                            DungeonBuilder builder = new DungeonBuilder(player.field_70170_p.func_72905_C(), cpos);
                            builder.build();
                            BuiltRoom room = builder.dungeon.getRoomForChunk(cpos);
                            ChunkProcessData data = new ChunkProcessData(chunk, room);
                            DungeonData dungeonData = mapdata.getData().getData(cpos);
                            boolean anyStructureBlocks = false;
                            if (dungeonData != null) {
                                for (Map.Entry entry : new HashMap(chunk.func_177434_r()).entrySet()) {
                                    TileEntity tile = (TileEntity)entry.getValue();
                                    if (!(tile instanceof StructureBlockTileEntity)) continue;
                                    BlockPos tilePos = (BlockPos)entry.getKey();
                                    StructureBlockTileEntity struc = (StructureBlockTileEntity)tile;
                                    CompoundNBT nbt = new CompoundNBT();
                                    struc.func_189515_b(nbt);
                                    String metadata = nbt.func_74779_i("metadata");
                                    boolean any = false;
                                    for (DataProcessor processor : DataProcessors.getAll()) {
                                        boolean did = processor.process(metadata, tilePos, (IWorld)player.field_70170_p, data);
                                        if (!did) continue;
                                        any = true;
                                    }
                                    if (any) {
                                        anyStructureBlocks = true;
                                        if (player.field_70170_p.func_180495_p(tilePos).func_177230_c() != Blocks.field_185779_df) continue;
                                        player.field_70170_p.func_180501_a(tilePos, Blocks.field_150350_a.func_176223_P(), 2);
                                        player.field_70170_p.func_175713_t(tilePos);
                                        continue;
                                    }
                                    System.out.println("Data block with tag: " + metadata + " matched no processors! " + tilePos.toString());
                                    ProcessChunkBlocks.logRoomForPos(player.field_70170_p, tilePos);
                                }
                                if (anyStructureBlocks) {
                                    c.setDone();
                                    chunk.func_76630_e();
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

