/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.auto_comp;

import com.google.common.collect.Multimap;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.forge.parts.AutoCompatibleItemConfig;
import com.robertx22.mine_and_slash.config.forge.parts.AutoConfigItemType;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.new_content.auto_comp.DeterminePowerLevels;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;

public class PowerLevel {
    public static HashMap<Item, Types> CACHED = new HashMap();
    public Item item;
    public int statAmount = 0;
    public float totalStatNumbers = 0.0f;

    public PowerLevel(Item item, GearItemSlot slot) {
        try {
            this.item = item;
            Multimap stats = item.func_111205_h(slot.getVanillaSlotType());
            this.statAmount = stats.size();
            int MAX_SINGLE_STAT_VALUE = (Integer)ModConfig.INSTANCE.autoCompatibleItems.MAX_SINGLE_STAT_VALUE.get();
            int MAX_TOTAL_STATS = (Integer)ModConfig.INSTANCE.autoCompatibleItems.MAX_TOTAL_STATS.get();
            this.totalStatNumbers = stats.values().stream().mapToInt(x -> (int)MathHelper.func_151237_a((double)x.func_111164_d(), (double)(-MAX_SINGLE_STAT_VALUE), (double)MAX_SINGLE_STAT_VALUE)).sum();
            this.totalStatNumbers = MathHelper.func_76131_a((float)this.totalStatNumbers, (float)(-MAX_TOTAL_STATS), (float)MAX_TOTAL_STATS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float getFloatValueOf(Item item) {
        List slots = SlashRegistry.GearTypes().getList().stream().filter(x -> GearItemSlot.isGearOfThisType(x, item)).collect(Collectors.toList());
        float val = 0.0f;
        for (GearItemSlot slot : slots) {
            PowerLevel power = new PowerLevel(item, slot);
            PowerLevel best = DeterminePowerLevels.STRONGEST.get(slot);
            val += power.divideBy(best);
        }
        return val *= (float)slots.size();
    }

    public static Types getPowerClassification(Item item) {
        if (CACHED.containsKey(item)) {
            return CACHED.get(item);
        }
        float val = PowerLevel.getFloatValueOf(item);
        AutoCompatibleItemConfig config = ModConfig.INSTANCE.autoCompatibleItems;
        Types type = null;
        if ((double)val > (Double)config.BEST.POWER_REQ.get()) {
            type = Types.BEST;
        }
        if ((double)val > (Double)config.NORMAL.POWER_REQ.get()) {
            type = Types.NORMAL;
        }
        if ((double)val > (Double)config.TRASH.POWER_REQ.get()) {
            type = Types.TRASH;
        }
        if (type == null) {
            type = Types.HORRIBLE;
        }
        CACHED.put(item, type);
        return type;
    }

    public boolean isStrongerThan(PowerLevel other) {
        return this.totalStatNumbers > other.totalStatNumbers;
    }

    public float divideBy(PowerLevel other) {
        return this.totalStatNumbers / other.totalStatNumbers;
    }

    public static enum Types {
        HORRIBLE{

            @Override
            public AutoConfigItemType getConfig() {
                return ModConfig.INSTANCE.autoCompatibleItems.HORRIBLE;
            }
        }
        ,
        TRASH{

            @Override
            public AutoConfigItemType getConfig() {
                return ModConfig.INSTANCE.autoCompatibleItems.TRASH;
            }
        }
        ,
        NORMAL{

            @Override
            public AutoConfigItemType getConfig() {
                return ModConfig.INSTANCE.autoCompatibleItems.NORMAL;
            }
        }
        ,
        BEST{

            @Override
            public AutoConfigItemType getConfig() {
                return ModConfig.INSTANCE.autoCompatibleItems.BEST;
            }
        };


        public abstract AutoConfigItemType getConfig();
    }
}

