/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.building;

import com.robertx22.mine_and_slash.new_content.BuiltRoom;
import com.robertx22.mine_and_slash.new_content.RoomSides;
import com.robertx22.mine_and_slash.new_content.UnbuiltRoom;
import com.robertx22.mine_and_slash.new_content.building.DungeonUtils;
import com.robertx22.mine_and_slash.new_content.enums.RoomSide;
import com.robertx22.mine_and_slash.new_content.enums.RoomType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class Dungeon {
    int capacity;
    private int size;
    private boolean started = false;
    int amount = 0;
    int ends = 0;
    public int bossRooms = 0;
    public int puzzleBlockRooms = 0;
    private BuiltRoom[][] rooms;
    private List<ImmutablePair<Integer, Integer>> unbuiltRooms = new ArrayList<ImmutablePair<Integer, Integer>>();

    public Dungeon(int size) {
        this(size, 20);
    }

    public Dungeon(int size, int capacity) {
        this.size = size;
        this.capacity = capacity;
        this.rooms = new BuiltRoom[capacity][capacity];
    }

    public List<ImmutablePair<Integer, Integer>> getUnbuiltCopy() {
        return new ArrayList<ImmutablePair<Integer, Integer>>(this.unbuiltRooms);
    }

    public void printDungeonAsSymbolsForDebug() {
        String all = "";
        for (int x = 0; x < this.capacity; ++x) {
            String line = "";
            for (int z = 0; z < this.capacity; ++z) {
                line = this.getRoom(x, z) != null ? line + this.getRoom((int)x, (int)z).data.type.id + ";" : line + "empty;";
            }
            all = all + line + "\n";
        }
        System.out.println(all);
    }

    public boolean isFinished() {
        return this.started && this.unbuiltRooms.isEmpty();
    }

    public boolean shouldStartFinishing() {
        return this.amount > this.size;
    }

    public BuiltRoom getRoomForChunk(ChunkPos pos) {
        try {
            ChunkPos start = DungeonUtils.getStartChunk(pos);
            ChunkPos relative = new ChunkPos(pos.field_77276_a - start.field_77276_a, pos.field_77275_b - start.field_77275_b);
            return this.rooms[this.getMiddle() + relative.field_77276_a][this.getMiddle() + relative.field_77275_b];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasRoomForChunk(ChunkPos pos) {
        return this.getRoomForChunk(pos) != null;
    }

    public BuiltRoom getRoom(int x, int z) {
        if (x > this.capacity || z > this.capacity || x < 0 || z < 0) {
            return null;
        }
        return this.rooms[x][z];
    }

    public int getMiddle() {
        return this.rooms.length / 2;
    }

    public ImmutablePair<Integer, Integer> getCoordsOfRoomFacing(Direction dir, int x, int z) {
        if (dir == Direction.NORTH) {
            return ImmutablePair.of((Object)x, (Object)(z - 1));
        }
        if (dir == Direction.SOUTH) {
            return ImmutablePair.of((Object)x, (Object)(z + 1));
        }
        if (dir == Direction.EAST) {
            return ImmutablePair.of((Object)(x + 1), (Object)z);
        }
        if (dir == Direction.WEST) {
            return ImmutablePair.of((Object)(x - 1), (Object)z);
        }
        throw new RuntimeException("getCoordsOfRoomFacing is null? Wrong direction?");
    }

    public void setupBarriers() {
        BuiltRoom built = BuiltRoom.getBarrier();
        for (int i = 0; i < this.rooms.length; ++i) {
            for (int j = 0; j < this.rooms[i].length; ++j) {
                if (i != 0 && j != 0 && i != this.rooms.length - 1 && j != this.rooms[i].length - 1) continue;
                this.addBarrier(i, j, built);
            }
        }
    }

    public void fillWithBarriers() {
        BuiltRoom built = BuiltRoom.getBarrier();
        for (int i = 0; i < this.rooms.length; ++i) {
            for (int j = 0; j < this.rooms[i].length; ++j) {
                if (this.getRoom(i, j) != null) continue;
                this.addBarrier(i, j, built);
            }
        }
    }

    public BuiltRoom getRoomFacing(Direction dir, int x, int z) {
        ImmutablePair<Integer, Integer> coords = this.getCoordsOfRoomFacing(dir, x, z);
        if (coords != null) {
            return this.getRoom((Integer)coords.left, (Integer)coords.right);
        }
        throw new RuntimeException("getRoomFacing is null? Wrong direction?");
    }

    public RoomSide getSideOfRoomFacing(Direction dir, int x, int z) {
        BuiltRoom room = this.getRoomFacing(dir, x, z);
        if (dir == Direction.NORTH) {
            return room != null ? room.data.sides.SOUTH : RoomSide.NONE;
        }
        if (dir == Direction.SOUTH) {
            return room != null ? room.data.sides.NORTH : RoomSide.NONE;
        }
        if (dir == Direction.EAST) {
            return room != null ? room.data.sides.WEST : RoomSide.NONE;
        }
        if (dir == Direction.WEST) {
            return room != null ? room.data.sides.EAST : RoomSide.NONE;
        }
        throw new RuntimeException("No room found facing in direction of: " + dir.toString() + ": " + x + " , " + z);
    }

    public UnbuiltRoom getUnbuiltFor(int x, int z) {
        RoomSide S = this.getSideOfRoomFacing(Direction.SOUTH, x, z);
        RoomSide N = this.getSideOfRoomFacing(Direction.NORTH, x, z);
        RoomSide E = this.getSideOfRoomFacing(Direction.EAST, x, z);
        RoomSide W = this.getSideOfRoomFacing(Direction.WEST, x, z);
        RoomSides sides = new RoomSides(S, N, E, W);
        UnbuiltRoom unbuilt = new UnbuiltRoom(sides);
        return unbuilt;
    }

    private void addUnbuilts(int x, int z, BuiltRoom room) {
        ArrayList<Direction> dirs = new ArrayList<Direction>();
        dirs.add(Direction.SOUTH);
        dirs.add(Direction.NORTH);
        dirs.add(Direction.WEST);
        dirs.add(Direction.EAST);
        dirs.forEach(dir -> {
            ImmutablePair<Integer, Integer> coord = this.getCoordsOfRoomFacing((Direction)dir, x, z);
            if (this.getRoom((Integer)coord.left, (Integer)coord.right) == null && room.data.sides.getSideOfDirection((Direction)dir) == RoomSide.DOOR) {
                this.unbuiltRooms.add(coord);
            }
        });
    }

    public void addBarrier(int x, int z, BuiltRoom room) {
        this.rooms[x][z] = room;
    }

    public void forceSetRoom(int x, int z, BuiltRoom room) {
        this.rooms[x][z] = room;
    }

    public void addRoom(int x, int z, BuiltRoom room) {
        if (room == null) {
            return;
        }
        if (this.rooms[x][z] == null) {
            this.rooms[x][z] = room;
            ++this.amount;
            if (room.data.type.equals(RoomType.END)) {
                ++this.ends;
            }
            if (room.room.isBoss) {
                ++this.bossRooms;
            }
            if (room.room.isPuzzleBlock) {
                ++this.puzzleBlockRooms;
            }
            this.started = true;
            this.addUnbuilts(x, z, room);
            this.unbuiltRooms.removeIf(cord -> (Integer)cord.left == x && (Integer)cord.right == z);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dungeon d = (Dungeon)o;
        return d.amount == this.amount && d.ends == this.ends;
    }

    public int hashCode() {
        return Objects.hash(this);
    }
}

