/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.building;

import com.google.common.base.Preconditions;
import com.robertx22.mine_and_slash.new_content.BuiltRoom;
import com.robertx22.mine_and_slash.new_content.RoomRotation;
import com.robertx22.mine_and_slash.new_content.UnbuiltRoom;
import com.robertx22.mine_and_slash.new_content.building.Dungeon;
import com.robertx22.mine_and_slash.new_content.building.DungeonUtils;
import com.robertx22.mine_and_slash.new_content.enums.RoomType;
import com.robertx22.mine_and_slash.new_content.registry.DungeonRoom;
import com.robertx22.mine_and_slash.new_content.registry.groups.RoomGroup;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.math.ChunkPos;

public class DungeonBuilder {
    public int maxPuzzleBlockRooms = 3;
    public boolean debug = false;
    public Dungeon dungeon;
    public final Random rand;
    public int size;
    public boolean isTesting = false;
    RoomGroup group;
    public int maxBossRooms = 1;

    public DungeonBuilder(long worldSeed, ChunkPos cpos) {
        int chunkX = DungeonUtils.getStartChunk((ChunkPos)cpos).field_77276_a;
        int chunkZ = DungeonUtils.getStartChunk((ChunkPos)cpos).field_77275_b;
        long newSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ worldSeed;
        this.rand = new Random(newSeed);
        this.group = (RoomGroup)RandomUtils.weightedRandom(RoomGroup.getAll().stream().filter(x -> x.canBeMainTheme).collect(Collectors.toList()), this.rand.nextDouble());
        this.size = RandomUtils.RandomRange(15, 25, this.rand);
        if (RandomUtils.roll(5.0, this.rand)) {
            ++this.maxBossRooms;
        }
    }

    public void build() {
        this.dungeon = new Dungeon(this.size);
        this.setupEntrance();
        this.dungeon.setupBarriers();
        for (int tries = 0; !this.dungeon.isFinished() || tries < 500; ++tries) {
            this.dungeon.getUnbuiltCopy().forEach(x -> {
                try {
                    UnbuiltRoom unbuilt = this.dungeon.getUnbuiltFor((Integer)x.left, (Integer)x.right);
                    Preconditions.checkNotNull((Object)unbuilt);
                    RoomRotation rot = this.randomDungeonRoom(unbuilt);
                    Preconditions.checkNotNull((Object)rot);
                    DungeonRoom dRoom = rot.type.getRandomRoom(this.group, this);
                    Preconditions.checkNotNull((Object)dRoom);
                    BuiltRoom room = new BuiltRoom(rot, dRoom);
                    Preconditions.checkNotNull((Object)room);
                    this.dungeon.addRoom((Integer)x.left, (Integer)x.right, room);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        this.dungeon.fillWithBarriers();
    }

    public RoomRotation randomDungeonRoom(UnbuiltRoom unbuilt) {
        if (this.dungeon.shouldStartFinishing()) {
            List<RoomRotation> pos = RoomType.END.getPossibleFor(unbuilt);
            if (pos.isEmpty()) {
                return this.randomRoom(unbuilt);
            }
            return this.random(pos);
        }
        return this.randomRoom(unbuilt);
    }

    public RoomRotation randomRoom(UnbuiltRoom unbuilt) {
        ArrayList<RoomType> types = new ArrayList<RoomType>();
        types.add(RoomType.CURVED_HALLWAY);
        types.add(RoomType.STRAIGHT_HALLWAY);
        types.add(RoomType.FOUR_WAY);
        types.add(RoomType.TRIPLE_HALLWAY);
        ArrayList<RoomRotation> possible = new ArrayList<RoomRotation>();
        types.forEach(x -> possible.addAll(x.getPossibleFor(unbuilt)));
        if (possible.isEmpty()) {
            possible.addAll(RoomType.END.getPossibleFor(unbuilt));
            if (possible.isEmpty()) {
                throw new RuntimeException("No possible rooms at all for unbuilt room, this is horrible.");
            }
        }
        return this.random(possible);
    }

    public RoomRotation random(List<RoomRotation> list) {
        return RandomUtils.weightedRandom(list, this.rand.nextDouble());
    }

    private void setupEntrance() {
        DungeonRoom entranceRoom = RoomType.ENTRANCE.getRandomRoom(this.group, this);
        ArrayList<RoomRotation> possible = new ArrayList<RoomRotation>();
        possible.addAll(RoomType.ENTRANCE.getRotations());
        RoomRotation rotation = this.random(possible);
        BuiltRoom entrance = new BuiltRoom(rotation, entranceRoom);
        int mid = this.dungeon.getMiddle();
        this.dungeon.addRoom(mid, mid, entrance);
    }
}

