/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.chests;

import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.new_content.chests.MapChestTile;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class MapChestBlock
extends AbstractChestBlock<MapChestTile> {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SINGLE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MapChestBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a), () -> (TileEntityType)ModTileEntities.MAP_CHEST.get());
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState blockstate, LootContext.Builder context) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tileentity = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof MapChestTile) {
            MapChestTile inv = (MapChestTile)tileentity;
            for (ItemStack stack : inv.func_190576_q()) {
                if (stack.func_190926_b()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new MapChestTile();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SINGLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.ICallback<MapChestTile, Float2FloatFunction> getLid(final IChestLid lid) {
        return new TileEntityMerger.ICallback<MapChestTile, Float2FloatFunction>(){

            public Float2FloatFunction func_225539_a_(MapChestTile block, MapChestTile block2) {
                return f -> Math.max(block.func_195480_a(f), block2.func_195480_a(f));
            }

            public Float2FloatFunction func_225538_a_(MapChestTile p_225538_1_) {
                return arg_0 -> ((MapChestTile)p_225538_1_).func_195480_a(arg_0);
            }

            public Float2FloatFunction func_225537_b_() {
                return arg_0 -> ((IChestLid)lid).func_195480_a(arg_0);
            }
        };
    }

    public TileEntityMerger.ICallbackWrapper<? extends MapChestTile> getWrapper(BlockState blockState, World world, BlockPos blockPos, boolean p_225536_4_) {
        BiPredicate<IWorld, BlockPos> biPredicate = p_225536_4_ ? (p_226918_0_, p_226918_1_) -> false : MapChestBlock::isBlocked;
        return TileEntityMerger.func_226924_a_((TileEntityType)((TileEntityType)ModTileEntities.MAP_CHEST.get()), MapChestBlock::getMergerType, MapChestBlock::getDirectionToAttached, (DirectionProperty)FACING, (BlockState)blockState, (IWorld)world, (BlockPos)blockPos, biPredicate);
    }

    public static TileEntityMerger.Type getMergerType(BlockState blockState) {
        return TileEntityMerger.Type.SINGLE;
    }

    public TileEntityMerger.ICallbackWrapper<? extends MapChestTile> func_225536_a_(BlockState state, World p_225536_2_, BlockPos p_225536_3_, boolean bool) {
        BiPredicate<IWorld, BlockPos> bipredicate = bool ? (world, pos) -> false : ChestBlock::func_220108_a;
        return TileEntityMerger.func_226924_a_((TileEntityType)((TileEntityType)this.field_226859_a_.get()), MapChestBlock::type, ChestBlock::func_196311_i, (DirectionProperty)FACING, (BlockState)state, (IWorld)p_225536_2_, (BlockPos)p_225536_3_, bipredicate);
    }

    public static TileEntityMerger.Type type(BlockState p_226919_0_) {
        return TileEntityMerger.Type.SINGLE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return super.func_204507_t(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        INamedContainerProvider inamedcontainerprovider;
        if (!worldIn.field_72995_K && (inamedcontainerprovider = this.func_220052_b(state, worldIn, pos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)inamedcontainerprovider, extraData -> extraData.func_179255_a(pos));
        }
        return ActionResultType.SUCCESS;
    }

    private static boolean isBlocked(IWorld iWorld, BlockPos blockPos) {
        return MapChestBlock.isBelowSolidBlock((IBlockReader)iWorld, blockPos) || MapChestBlock.isCatSittingOn(iWorld, blockPos);
    }

    private static boolean isBelowSolidBlock(IBlockReader iBlockReader, BlockPos worldIn) {
        BlockPos blockpos = worldIn.func_177984_a();
        return iBlockReader.func_180495_p(blockpos).func_215686_e(iBlockReader, blockpos);
    }

    private static boolean isCatSittingOn(IWorld iWorld, BlockPos blockPos) {
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return direction.func_176735_f();
    }
}

