/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.data_processors;

import com.robertx22.mine_and_slash.database.bosses.base.Boss;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.rarities.mobs.BossMobRarity;
import com.robertx22.mine_and_slash.database.rarities.mobs.CommonMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.EpicMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.LegendaryMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.RareMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.UncommonMob;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.new_content.data_processors.bases.ChunkProcessData;
import com.robertx22.mine_and_slash.new_content.data_processors.bases.SpawnedMob;
import com.robertx22.mine_and_slash.new_content.registry.DataProcessor;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.MobSpawnUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ComplexMobProcessor
extends DataProcessor {
    public ComplexMobProcessor() {
        super("spawn", DataProcessor.Type.CONTAINS);
    }

    @Override
    public void processImplementation(String key, BlockPos pos, IWorld world, ChunkProcessData data) {
        try {
            String[] parts = StringUtils.split((String)key, (String)";");
            MobRarity rarity = null;
            boolean isBoss = false;
            EntityType type = null;
            boolean addPotion = false;
            Stream<SpawnedMob> filter = null;
            int amount = 1;
            for (String x2 : parts) {
                int am = 0;
                try {
                    am = Integer.parseInt(x2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (am <= 0) continue;
                amount = am;
            }
            for (String x2 : parts) {
                if (x2.equals("common")) {
                    rarity = CommonMob.getInstance();
                    continue;
                }
                if (x2.equals("uncommon")) {
                    rarity = UncommonMob.getInstance();
                    continue;
                }
                if (x2.equals("rare")) {
                    rarity = RareMob.getInstance();
                    continue;
                }
                if (x2.equals("epic")) {
                    rarity = EpicMob.getInstance();
                    continue;
                }
                if (x2.equals("legendary")) {
                    rarity = LegendaryMob.getInstance();
                    continue;
                }
                if (x2.equals("mythic")) {
                    rarity = LegendaryMob.getInstance();
                    continue;
                }
                if (!x2.equals("boss")) continue;
                rarity = BossMobRarity.getInstance();
                isBoss = true;
            }
            if (rarity == null) {
                rarity = (MobRarity)Rarities.Mobs.random();
            }
            for (String x2 : parts) {
                ResourceLocation loc = new ResourceLocation(x2);
                if (!ForgeRegistries.ENTITIES.containsKey(loc)) continue;
                type = (EntityType)ForgeRegistries.ENTITIES.getValue(loc);
            }
            if (type == null) {
                for (String x2 : parts) {
                    if (x2.equals("ranged")) {
                        filter = SpawnedMob.getAll().stream().filter(m -> m.isRanged);
                        continue;
                    }
                    if (x2.equals("spider")) {
                        filter = SpawnedMob.getAll().stream().filter(m -> m.isSpider);
                        continue;
                    }
                    if (!x2.equals("nether")) continue;
                    filter = SpawnedMob.getAll().stream().filter(m -> m.isNether);
                }
            }
            if (filter == null) {
                filter = SpawnedMob.getAll().stream().filter(x -> data.getRoom().canSpawnMob((SpawnedMob)x));
            }
            if (type == null) {
                if (isBoss) {
                    filter = filter.filter(m -> m.canBeBoss);
                }
                type = ((SpawnedMob)RandomUtils.weightedRandom((Collection)filter.collect(Collectors.toList()))).type;
            }
            Boss boss = null;
            if (isBoss) {
                boss = data.getRoom().group.canSpawnFireMobs ? SlashRegistry.Bosses().random() : SlashRegistry.Bosses().getFilterWrapped(x -> !x.isFire).random();
            }
            for (int i = 0; i < amount; ++i) {
                MobSpawnUtils.summon(type, world, pos, rarity, addPotion, boss);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

