/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.data_processors.bases;

import com.robertx22.mine_and_slash.new_content.registry.DungeonRoom;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;

public class SpawnedMob
implements IWeighted {
    private static List<SpawnedMob> all = new ArrayList<SpawnedMob>();
    public EntityType<? extends MobEntity> type;
    public boolean isRanged = false;
    public boolean isSpider = false;
    public boolean isNether = false;
    public boolean isFire = false;
    int weight = 1000;
    public boolean canBeBoss = true;

    public SpawnedMob(EntityType<? extends MobEntity> type, int weight) {
        this.type = type;
        this.weight = weight;
    }

    public static SpawnedMob random(DungeonRoom room) {
        return (SpawnedMob)RandomUtils.weightedRandom(SpawnedMob.getAll().stream().filter(x -> room.canSpawnMob((SpawnedMob)x)).collect(Collectors.toList()));
    }

    public static List<SpawnedMob> getAll() {
        if (all.isEmpty()) {
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200725_aD, 1200));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200722_aA, 50).setNether());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200741_ag, 400).setRanged().setNether());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200792_f, 20).setRanged().setFire().setNether());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200771_K, 10).setFire().setNether());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200804_r, 5));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200794_h, 200).setSpider());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200748_an, 300).setSpider());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_220350_aJ, 500).setRanged());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200759_ay, 100).setRanged());
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200758_ax, 25));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200743_ai, 5));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200806_t, 2));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200764_D, 30));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200763_C, 500));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_220352_aU, 10).setCanBeBoss(false));
            all.add(new SpawnedMob((EntityType<? extends MobEntity>)EntityType.field_200750_ap, 300).setRanged());
        }
        return all;
    }

    public SpawnedMob setRanged() {
        this.isRanged = true;
        return this;
    }

    public SpawnedMob setNether() {
        this.isNether = true;
        return this;
    }

    public SpawnedMob setSpider() {
        this.isSpider = true;
        return this;
    }

    public SpawnedMob setFire() {
        this.isFire = true;
        return this;
    }

    public SpawnedMob setCanBeBoss(Boolean bool) {
        this.canBeBoss = bool;
        return this;
    }

    @Override
    public int Weight() {
        return this.weight;
    }
}

