/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.enums;

import com.robertx22.mine_and_slash.new_content.RoomRotation;
import com.robertx22.mine_and_slash.new_content.RoomSides;
import com.robertx22.mine_and_slash.new_content.UnbuiltRoom;
import com.robertx22.mine_and_slash.new_content.building.DungeonBuilder;
import com.robertx22.mine_and_slash.new_content.enums.RoomSide;
import com.robertx22.mine_and_slash.new_content.registry.DungeonRoom;
import com.robertx22.mine_and_slash.new_content.registry.groups.RoomGroup;
import com.robertx22.mine_and_slash.new_content.registry.rooms.RoomList;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.Rotation;

public enum RoomType implements IWeighted
{
    FOUR_WAY("four_way"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR), Rotation.NONE));
            return all;
        }
    }
    ,
    STRAIGHT_HALLWAY("straight_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    CURVED_HALLWAY("curved_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    TRIPLE_HALLWAY("triple_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    END("end"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    ENTRANCE("entrance"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    };

    public RoomSides sides;
    public String id;

    private RoomType(String id) {
        this.id = id;
    }

    public final DungeonRoom getTestRoom() {
        return new DungeonRoom("test", this, RoomGroup.TEST).setTest();
    }

    public abstract List<RoomRotation> getRotations();

    public final List<DungeonRoom> getAllOfThisTypeRooms() {
        return RoomList.getAllRooms().stream().filter(x -> x.type.equals(this)).collect(Collectors.toList());
    }

    public DungeonRoom getRandomRoom(RoomGroup group, DungeonBuilder builder) {
        RoomGroup tryGroup;
        if (builder.debug) {
            return this.getTestRoom();
        }
        RoomGroup g = group;
        if (g.allowsOtherTypes() && RandomUtils.roll(group.chanceForOtherGroups, builder.rand) && (tryGroup = RandomUtils.weightedRandom(group.possibleOtherTypes(), builder.rand.nextDouble())).hasRoomFor(this)) {
            g = tryGroup;
        }
        List<DungeonRoom> possible = new ArrayList<DungeonRoom>();
        for (DungeonRoom x2 : this.getAllOfThisTypeRooms()) {
            if (!x2.group.equals(g)) continue;
            possible.add(x2);
        }
        if (possible.isEmpty()) {
            RoomGroup fallback = group.getFallbackGroup(builder.rand);
            possible.addAll(RoomList.getAllRooms().stream().filter(x -> x.type.equals(this) && x.group.equals(fallback)).collect(Collectors.toList()));
        }
        if (possible.isEmpty()) {
            System.out.println("No possible rooms?");
        }
        if (builder.dungeon.bossRooms >= builder.maxBossRooms) {
            possible = RoomType.tryFilter(possible, r -> !r.isBoss);
        }
        if (builder.dungeon.puzzleBlockRooms >= builder.maxPuzzleBlockRooms) {
            possible = RoomType.tryFilter(possible, r -> !r.isPuzzleBlock);
        }
        return RandomUtils.weightedRandom(possible, builder.rand.nextDouble());
    }

    public static List<DungeonRoom> tryFilter(List<DungeonRoom> rooms, Predicate<DungeonRoom> pred) {
        List<DungeonRoom> filtered = rooms.stream().filter(pred).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return rooms;
        }
        return filtered;
    }

    public List<RoomRotation> getPossibleFor(UnbuiltRoom room) {
        return this.getRotations().stream().filter(x -> x.sides.matches(room.sides)).collect(Collectors.toList());
    }

    @Override
    public int Weight() {
        return 1000;
    }
}

