/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.trader;

import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public interface ISellPrice {
    public static final String LOC = "mmorpg:sell_price";

    public int getSavedPriceInCommonOres();

    public static void removePrice(ItemStack stack) {
        try {
            stack.func_77978_p().func_82580_o(LOC);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getSavedPriceInCommonOres(ItemStack stack) {
        try {
            return stack.func_77978_p().func_74762_e(LOC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public static boolean hasPrice(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(LOC);
    }

    public static void savePriceInCommonOres(ItemStack stack, int ores) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(LOC, ores);
    }

    public static boolean hasEnoughMoney(PlayerEntity player, int needed) {
        int current = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof ItemOre)) continue;
            ItemOre ore = (ItemOre)stack.func_77973_b();
            current += stack.func_190916_E() * ore.getValueInCommonOres();
        }
        return current >= needed;
    }

    public static void spendMoney(PlayerEntity player, int toSpend) {
        for (ItemStack stack : new ArrayList(player.field_71071_by.field_70462_a)) {
            if (!(stack.func_77973_b() instanceof ItemOre)) continue;
            ItemOre ore = (ItemOre)stack.func_77973_b();
            int c = stack.func_190916_E();
            for (int i = 0; i < c; ++i) {
                if (toSpend <= 0 || stack.func_190916_E() <= 0) continue;
                int val = ore.getValueInCommonOres();
                stack.func_190918_g(1);
                toSpend -= val;
                player.field_71071_by.func_70296_d();
            }
        }
        if (toSpend > 0) {
            try {
                throw new RuntimeException("Tried to spend money when player didn't have enough!");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        if (toSpend < 0) {
            ISellPrice.giveBackChange(player, Math.abs(toSpend));
        }
    }

    public static ImmutablePair<Rarity, Integer> commonOresToBiggestPossibleRarity(int ores) {
        int rarity = 0;
        for (int i = 0; i < 6; ++i) {
            if (rarity >= 4 || ores < 9) continue;
            ores /= 9;
            ++rarity;
        }
        return ImmutablePair.of(Rarities.Gears.get(rarity), (Object)ores);
    }

    public static HashMap<Rarity, Integer> commonOresToExactListOfHigherRarities(int ores) {
        HashMap<Rarity, Integer> map = new HashMap<Rarity, Integer>();
        int rarity = 0;
        for (int i = 0; i < 6; ++i) {
            if (rarity >= 4 || ores < 9) continue;
            int rem = ores % 9;
            if (rem > 0) {
                Object rar = Rarities.Gears.get(rarity);
                map.put((Rarity)rar, map.getOrDefault(rar, 0) + rem);
            }
            ores /= 9;
            ++rarity;
        }
        Object rar = Rarities.Gears.get(rarity);
        map.put((Rarity)rar, map.getOrDefault(rar, 0) + ores);
        return map;
    }

    public static ItemStack getHighestRarityStackFromCommons(int ores) {
        ItemStack stack = ItemStack.field_190927_a;
        ImmutablePair<Rarity, Integer> pair = ISellPrice.commonOresToBiggestPossibleRarity(ores);
        Rarity rar = (Rarity)pair.left;
        int amount = (Integer)pair.right;
        if (amount > 0) {
            stack = new ItemStack((IItemProvider)ItemOre.ItemOres.get(rar.Rank()));
            stack.func_190920_e(amount);
        }
        return stack;
    }

    public static void giveBackChange(PlayerEntity player, int change) {
        ItemStack stack = ISellPrice.getHighestRarityStackFromCommons(change);
        PlayerUtils.giveItem(stack, player);
    }

    public static int rarityOresToCommons(Rarity rar, int ores) {
        return (int)((double)ores * Math.pow(9.0, MathHelper.func_76125_a((int)rar.Rank(), (int)1, (int)6)));
    }
}

