/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.new_content.trader;

import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.new_content.trader.ISellPrice;
import com.robertx22.mine_and_slash.new_content.trader.TraderData;
import com.robertx22.mine_and_slash.packets.trader.TraderPacket;
import com.robertx22.mine_and_slash.uncommon.datasaving.TraderSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class TraderEntity
extends VillagerEntity
implements IEntityAdditionalSpawnData {
    public TraderData data = new TraderData();

    public TraderEntity(World world) {
        super(EntityRegister.TRADER, world);
        this.init();
    }

    public TraderEntity(EntityType type, World world) {
        super(type, world);
        this.init();
    }

    public TraderEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.TRADER, world);
        this.init();
    }

    public void init() {
        this.func_175501_a(100000, false);
        this.func_110195_a(10000);
    }

    public void tryBuyItem(PlayerEntity player, int item) {
        ItemStack stack = this.data.stacks.get(item);
        int price = ISellPrice.getSavedPriceInCommonOres(stack);
        if (price < 1) {
            return;
        }
        if (ISellPrice.hasEnoughMoney(player, price)) {
            ISellPrice.spendMoney(player, price);
            ISellPrice.removePrice(stack);
            player.func_70099_a(stack, 1.0f);
            this.data.stacks.set(item, ItemStack.field_190927_a);
            SoundUtils.playSound((Entity)this, SoundEvents.field_187914_gn, 1.0f, 1.0f);
        } else {
            SoundUtils.playSound((Entity)this, SoundEvents.field_187913_gm, 1.0f, 1.0f);
        }
        MMORPG.sendToClient(new TraderPacket(this.data, this), (ServerPlayerEntity)player);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !WorldUtils.isMapWorldClass((IWorld)this.field_70170_p)) {
            this.func_70665_d(DamageSource.field_76368_d, 2.1474836E9f);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.data.generated) {
            this.data.generated = true;
            this.data.generateMerchandise(new LootInfo(this.field_70170_p, this.func_180425_c()));
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.data = TraderSaving.Load(nbt);
        if (this.data == null) {
            this.data = new TraderData();
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        TraderSaving.Save(nbt, this.data);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        buf.func_150786_a(nbt);
    }

    public void readSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        this.func_70037_a(nbt);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            MMORPG.sendToClient(new TraderPacket(this.data, this), (ServerPlayerEntity)player);
        }
        return true;
    }
}

