/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.data_gen;

import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;

public interface ISerializable<T> {
    public static final String ID = "id";
    public static final String REGISTRY = "registry";
    public static final String LANG_NAME = "lang_file_string";
    public static final String LANG_DESC = "lang_file_desc_string";
    public static final String WEIGHT = "weight";
    public static final String RARITY = "rarity";
    public static final String TIER = "tier";

    public JsonObject toJson();

    public T fromJson(JsonObject var1);

    default public String datapackFolder() {
        return "";
    }

    default public String getGUIDFromJson(JsonObject json) {
        return json.get(ID).getAsString();
    }

    default public int getTierFromJson(JsonObject json) {
        return json.get(TIER).getAsInt();
    }

    default public int getWeightFromJson(JsonObject json) {
        return json.get(WEIGHT).getAsInt();
    }

    default public int getRarityFromJson(JsonObject json) {
        return json.get(RARITY).getAsInt();
    }

    default public String getLangDescStringFromJson(JsonObject json) {
        return json.get(LANG_DESC).getAsString();
    }

    default public String getLangNameStringFromJson(JsonObject json) {
        return json.get(LANG_NAME).getAsString();
    }

    default public JsonObject getDefaultJson() {
        IBaseAutoLoc loc;
        Object claz;
        JsonObject json = new JsonObject();
        if (this instanceof IGUID) {
            claz = (IGUID)((Object)this);
            json.addProperty(ID, claz.GUID());
        }
        if (this instanceof IWeighted) {
            claz = (IWeighted)((Object)this);
            json.addProperty(WEIGHT, (Number)claz.Weight());
        }
        if (this instanceof IRarity) {
            claz = (IRarity)((Object)this);
            json.addProperty(RARITY, (Number)claz.getRarityRank());
        }
        if (this instanceof ITiered) {
            claz = (ITiered)((Object)this);
            json.addProperty(TIER, (Number)claz.getTier());
        }
        if (this instanceof ISlashRegistryEntry) {
            claz = (ISlashRegistryEntry)((Object)this);
            json.addProperty(REGISTRY, claz.getSlashRegistryType().id);
        }
        if (this instanceof IAutoLocName) {
            loc = (IAutoLocName)((Object)this);
            json.addProperty(LANG_NAME, loc.formattedLocNameLangFileGUID());
        }
        if (this instanceof IAutoLocDesc) {
            loc = (IAutoLocDesc)((Object)this);
            json.addProperty(LANG_DESC, loc.formattedLocDescLangFileGUID());
        }
        return json;
    }
}

